/*
 * Decompiled with CFR 0.152.
 */
package de.cristelknight999.t_and_t.utils;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.RepositorySource;
import org.jetbrains.annotations.NotNull;

public class RepositorySourceMaker
implements RepositorySource {
    private static final FileFilter DATAPACK_FILTER = pack -> {
        if (pack.isFile() && pack.getName().endsWith(".zip")) {
            try {
                FileSystem pfs = FileSystems.newFileSystem(pack.toPath());
                Path pth = pfs.getPath("data/", new String[0]);
                return Files.exists(pth, new LinkOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
                return false;
            }
        }
        return pack.isDirectory() && new File(pack, "pack.mcmeta").isFile() && new File(pack, "data/").exists();
    };
    private final Map<Path, FilePackType> packs = new HashMap<Path, FilePackType>();

    public RepositorySourceMaker(Set<Path> files) {
        for (Path file : files) {
            this.packs.put(file, FilePackType.MISSING);
        }
    }

    private void updatePacks() {
        for (Path file : this.packs.keySet()) {
            if (Files.isRegularFile(file, new LinkOption[0]) && file.endsWith(".zip")) {
                this.packs.put(file, FilePackType.ZIPED_PACK);
            } else if (Files.isDirectory(file, new LinkOption[0]) && Files.exists(file.resolve("pack.mcmeta"), new LinkOption[0])) {
                this.packs.put(file, FilePackType.UNZIPED_PACK);
            } else {
                try {
                    if (Files.notExists(file, new LinkOption[0])) {
                        Files.createDirectories(file, new FileAttribute[0]);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            this.packs.put(file, FilePackType.PACK_FOLDER);
        }
    }

    public void m_7686_(@NotNull Consumer<Pack> packConsumer) {
        this.updatePacks();
        block4: for (Path file : this.packs.keySet()) {
            FilePackType type = this.packs.get(file);
            switch (type) {
                case UNZIPED_PACK: 
                case ZIPED_PACK: {
                    Pack pack = Pack.m_245429_((String)file.getFileName().toString(), (Component)Component.m_237113_((String)file.getFileName().toString()), (boolean)true, string -> this.createSupplier(file, file.getFileName().toString()), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                    if (pack == null) break;
                    packConsumer.accept(pack);
                    break;
                }
                case PACK_FOLDER: {
                    Pack pack;
                    File[] afile = file.toFile().listFiles(DATAPACK_FILTER);
                    if (afile == null) continue block4;
                    for (File packFile : afile) {
                        pack = Pack.m_245429_((String)packFile.getName(), (Component)Component.m_237113_((String)file.getFileName().toString()), (boolean)true, string -> this.createSupplier(file, packFile.getName()), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
                        if (pack == null) continue;
                        packConsumer.accept(pack);
                    }
                    continue block4;
                }
            }
        }
    }

    private PackResources createSupplier(Path pack, String name) {
        return Files.isDirectory(pack, new LinkOption[0]) ? new PathPackResources(name, pack, true) : new FilePackResources(name, pack.toFile(), true);
    }

    private static enum FilePackType {
        MISSING,
        ZIPED_PACK,
        UNZIPED_PACK,
        PACK_FOLDER;

    }
}

