/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.abilities;

import com.sekwah.narutomod.capabilities.CooldownTickEvent;
import com.sekwah.narutomod.capabilities.INinjaData;
import com.sekwah.narutomod.registries.NarutoRegistries;
import com.sekwah.narutomod.sounds.NarutoSounds;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;

public abstract class Ability {
    public long defaultCombo() {
        return -1L;
    }

    public abstract ActivationType activationType();

    public abstract boolean handleCost(Player var1, INinjaData var2, int var3);

    public boolean handleCost(Player player, INinjaData ninjaData) {
        return this.handleCost(player, ninjaData, 0);
    }

    public boolean logInChat() {
        return true;
    }

    public SoundEvent castingSound() {
        return (SoundEvent)NarutoSounds.JUTSU_CAST.get();
    }

    public SoundEvent castingFailSound() {
        return (SoundEvent)NarutoSounds.JUTSU_FAIL.get();
    }

    public String getTranslationKey(INinjaData ninjaData) {
        Optional resourceKey = NarutoRegistries.ABILITIES.getResourceKey((Object)this);
        return this.getTranslationKey(ninjaData, 0);
    }

    public String getTranslationKey(INinjaData ninjaData, int ticksActive) {
        Optional resourceKey = NarutoRegistries.ABILITIES.getResourceKey((Object)this);
        if (resourceKey.isPresent()) {
            return ((ResourceKey)resourceKey.get()).m_135782_().toString();
        }
        return "";
    }

    public abstract void performServer(Player var1, INinjaData var2, int var3);

    public void performServer(Player player, INinjaData ninjaData) {
        this.performServer(player, ninjaData, 0);
    }

    public static interface Cooldown {
        public int getCooldown();

        default public boolean checkCooldown(Player player, INinjaData ninjaData, String translationKey) {
            if (this.getCooldown() > 0 && ninjaData.getCooldownEvents().containsKey(translationKey)) {
                player.m_5661_((Component)Component.m_237110_((String)"jutsu.fail.cooldown", (Object[])new Object[]{Component.m_237115_((String)translationKey).m_130940_(ChatFormatting.YELLOW), Component.m_237113_((String)String.valueOf((int)Math.ceil((float)ninjaData.getCooldownEvents().get((Object)translationKey).ticks / 20.0f))).m_130940_(ChatFormatting.YELLOW)}), true);
                return true;
            }
            return false;
        }

        default public void registerCooldown(INinjaData ninjaData, String translationKey) {
            if (this.getCooldown() > 0) {
                ninjaData.getCooldownEvents().put(translationKey, new CooldownTickEvent(this.getCooldown()));
            }
        }
    }

    public static interface HandleEnded {
        public void handleAbilityEnded(Player var1, INinjaData var2, int var3);
    }

    public static interface Channeled {
        default public boolean canActivateBelowMinCharge() {
            return true;
        }

        default public boolean useChargedMessages() {
            return false;
        }

        default public boolean hideChannelMessages() {
            return false;
        }

        default public void handleChannelling(Player player, INinjaData ninjaData, int ticksChanneled) {
        }
    }

    public static interface Toggled {
        public void performToggleClient(Player var1, INinjaData var2);
    }

    public static enum ActivationType {
        INSTANT,
        TOGGLE,
        CHANNELED;

    }
}

