/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.abilities;

import com.mojang.logging.LogUtils;
import com.sekwah.narutomod.abilities.Ability;
import com.sekwah.narutomod.abilities.jutsus.FireballJutsuAbility;
import com.sekwah.narutomod.abilities.jutsus.SubstitutionJutsuAbility;
import com.sekwah.narutomod.abilities.jutsus.WaterBulletJutsuAbility;
import com.sekwah.narutomod.abilities.utility.ChakraChargeAbility;
import com.sekwah.narutomod.abilities.utility.DoubleJumpAbility;
import com.sekwah.narutomod.abilities.utility.LeapAbility;
import com.sekwah.narutomod.abilities.utility.WaterWalkAbility;
import com.sekwah.narutomod.network.PacketHandler;
import com.sekwah.narutomod.network.c2s.ServerAbilityActivatePacket;
import com.sekwah.narutomod.network.c2s.ServerAbilityChannelPacket;
import com.sekwah.narutomod.registries.NarutoRegistries;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="narutomod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class NarutoAbilities {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister<Ability> ABILITY = DeferredRegister.create((ResourceLocation)NarutoRegistries.ABILITY_REGISTRY_LOC, (String)"narutomod");
    public static final Map<Long, ResourceLocation> COMBO_MAP = new HashMap<Long, ResourceLocation>();
    public static final RegistryObject<LeapAbility> LEAP = ABILITY.register("leap", LeapAbility::new);
    public static final RegistryObject<WaterWalkAbility> WATER_WALK = ABILITY.register("water_walk", WaterWalkAbility::new);
    public static final RegistryObject<FireballJutsuAbility> FIREBALL = ABILITY.register("fireball", FireballJutsuAbility::new);
    public static final RegistryObject<WaterBulletJutsuAbility> WATER_BULLET = ABILITY.register("water_bullet", WaterBulletJutsuAbility::new);
    public static final RegistryObject<ChakraChargeAbility> CHAKRA_CHARGE = ABILITY.register("chakra_charge", ChakraChargeAbility::new);
    public static final RegistryObject<DoubleJumpAbility> DOUBLE_JUMP = ABILITY.register("double_jump", DoubleJumpAbility::new);
    public static final RegistryObject<SubstitutionJutsuAbility> SUBSTITUTION = ABILITY.register("substitution", SubstitutionJutsuAbility::new);

    public static void register(IEventBus eventBus) {
        ABILITY.register(eventBus);
    }

    public static void registerKeyCombos() {
        ABILITY.getEntries().forEach(abilityEntry -> {
            Ability ability = (Ability)abilityEntry.get();
            long combo = ability.defaultCombo();
            if (combo > 0L) {
                if (COMBO_MAP.containsKey(combo)) {
                    LOGGER.error("Ability already registered with that combo {}", (Object)combo);
                } else {
                    NarutoRegistries.ABILITIES.getResourceKey((Object)ability).ifPresent(resourceKey -> COMBO_MAP.put(combo, resourceKey.m_135782_()));
                }
            }
        });
    }

    public static void triggerAbility(ResourceLocation ability) {
        PacketHandler.sendToServer(new ServerAbilityActivatePacket(ability));
    }

    public static Ability getAbilityFromCombo(long combo) {
        if (COMBO_MAP.containsKey(combo)) {
            return (Ability)NarutoRegistries.ABILITIES.getValue(COMBO_MAP.get(combo));
        }
        return null;
    }

    public static boolean handleCharging(long combo, ServerAbilityChannelPacket.ChannelStatus channelStatus) {
        if (COMBO_MAP.containsKey(combo)) {
            ResourceLocation abilityResource = COMBO_MAP.get(combo);
            PacketHandler.sendToServer(new ServerAbilityChannelPacket(abilityResource, channelStatus));
            return true;
        }
        return false;
    }

    public static boolean triggerAbility(long combo) {
        if (COMBO_MAP.containsKey(combo)) {
            NarutoAbilities.triggerAbility(COMBO_MAP.get(combo));
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public static void clientSetup(FMLCommonSetupEvent event) {
        NarutoAbilities.registerKeyCombos();
    }
}

