/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.abilities.jutsus;

import com.sekwah.narutomod.abilities.Ability;
import com.sekwah.narutomod.capabilities.INinjaData;
import com.sekwah.narutomod.entity.SubstitutionLogEntity;
import com.sekwah.narutomod.sounds.NarutoSounds;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class SubstitutionJutsuAbility
extends Ability
implements Ability.Channeled {
    public static int MAX_MARKER_DISTANCE = 70;

    @Override
    public Ability.ActivationType activationType() {
        return Ability.ActivationType.CHANNELED;
    }

    @Override
    public long defaultCombo() {
        return 12L;
    }

    @Override
    public boolean handleCost(Player player, INinjaData ninjaData, int chargeAmount) {
        if (ninjaData.getSubstitutionCount() < 1.0f && chargeAmount == -1) {
            player.m_5661_((Component)Component.m_237110_((String)"jutsu.fail.notenoughcharges", (Object[])new Object[]{Component.m_237115_((String)this.getTranslationKey(ninjaData)).m_130940_(ChatFormatting.YELLOW)}), true);
            player.m_6330_((SoundEvent)NarutoSounds.JUTSU_FAIL.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            return false;
        }
        return true;
    }

    @Override
    public String getTranslationKey(INinjaData ninjaData, int ticksActive) {
        String mainString = super.getTranslationKey(ninjaData, ticksActive);
        if (ticksActive <= 1) {
            return mainString;
        }
        return mainString + ".mark";
    }

    @Override
    public void performServer(Player player, INinjaData ninjaData, int ticksActive) {
        if (ticksActive == -1) {
            Vec3 loc;
            double distance;
            if (!player.m_7500_()) {
                ninjaData.useSubstitution(1.0f);
            }
            double d = distance = (loc = ninjaData.getSubstitutionLoc()) != null ? player.m_20182_().m_82554_(loc) : 0.0;
            if (loc != null && Math.round(distance) <= (long)MAX_MARKER_DISTANCE && player.f_19853_.m_46472_().m_135782_().equals((Object)ninjaData.getSubstitutionDimension())) {
                this.spawnLogAt(player, player.m_20182_(), ninjaData);
                player.m_6021_(loc.f_82479_, loc.f_82480_ - 2.0, loc.f_82481_);
                ninjaData.setSubstitutionLoc(null, null);
            } else {
                Vec3 originalPosition = player.m_20182_();
                if (this.randomTeleportPlayer(player, ninjaData)) {
                    this.spawnLogAt(player, originalPosition, ninjaData);
                }
            }
        } else {
            ninjaData.setSubstitutionLoc(player.m_20182_().m_82520_(0.0, 2.0, 0.0), player.f_19853_.m_46472_().m_135782_());
        }
    }

    public void spawnLogAt(Player player, Vec3 pos, INinjaData ninjaData) {
        ninjaData.setInvisibleTicks(5);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 5, 0, false, false));
        SubstitutionLogEntity log = new SubstitutionLogEntity(player.f_19853_);
        log.m_146884_(pos.m_82520_(0.0, 1.0, 0.0));
        player.f_19853_.m_7967_((Entity)log);
        Level level = player.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, pos.f_82479_, pos.f_82480_ + (double)(player.m_20206_() / 2.0f), pos.f_82481_, 100, 0.5, 0.7, 0.5, 0.0);
        }
    }

    public boolean randomTeleportPlayer(Player player, INinjaData ninjaData) {
        for (int i = 0; i < 16; ++i) {
            double z;
            double y;
            double x = player.m_20185_() + (player.m_217043_().m_188500_() - 0.5) * 25.0;
            if (!(Math.sqrt(player.m_20275_(x, y = Mth.m_14008_((double)(player.m_20186_() + (double)(player.m_217043_().m_188503_(16) - 8)), (double)player.f_19853_.m_141937_(), (double)(player.f_19853_.m_141937_() + ((ServerLevel)player.f_19853_).m_143344_() - 1)), z = player.m_20189_() + (player.m_217043_().m_188500_() - 0.5) * 25.0)) >= 10.0) || !player.m_20984_(x, y, z, false)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hideChannelMessages() {
        return false;
    }

    @Override
    public boolean useChargedMessages() {
        return true;
    }
}

