/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.abilities.utility;

import com.sekwah.narutomod.abilities.Ability;
import com.sekwah.narutomod.capabilities.INinjaData;
import com.sekwah.narutomod.gameevents.NarutoGameEvents;
import com.sekwah.narutomod.sounds.NarutoSounds;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class DoubleJumpAbility
extends Ability {
    public static final float CHAKRA_COST = 2.0f;
    public static final float STAMINA_COST = 5.0f;

    @Override
    public Ability.ActivationType activationType() {
        return Ability.ActivationType.INSTANT;
    }

    @Override
    public boolean logInChat() {
        return false;
    }

    @Override
    public SoundEvent castingSound() {
        return null;
    }

    @Override
    public SoundEvent castingFailSound() {
        return null;
    }

    @Override
    public boolean handleCost(Player player, INinjaData ninjaData, int chargeAmount) {
        return ninjaData.getDoubleJumpData().canDoubleJumpServer;
    }

    @Override
    public void performServer(Player player, INinjaData ninjaData, int ticksActive) {
        ninjaData.useChakra(2.0f, 30);
        ninjaData.useStamina(5.0f, 40);
        Level level = player.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, player.m_20185_(), player.m_20186_() + (double)0.1f, player.m_20189_(), 35, 0.0, 0.0, 0.0, (double)0.6f);
        }
        ninjaData.getDoubleJumpData().canDoubleJumpServer = false;
        player.f_19789_ = 0.0f;
        player.m_9236_().m_6269_(null, (Entity)player, (SoundEvent)NarutoSounds.DOUBLE_JUMP.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        player.m_9236_().m_220400_((Entity)player, (GameEvent)NarutoGameEvents.DOUBLE_JUMP.get(), player.m_20182_());
    }
}

