/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.abilities.utility;

import com.sekwah.narutomod.abilities.Ability;
import com.sekwah.narutomod.capabilities.INinjaData;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;

public class WaterWalkAbility
extends Ability
implements Ability.Toggled {
    private final int CHARKA_COOLDOWN = 15;

    @Override
    public Ability.ActivationType activationType() {
        return Ability.ActivationType.TOGGLE;
    }

    @Override
    public long defaultCombo() {
        return 3L;
    }

    @Override
    public boolean handleCost(Player player, INinjaData ninjaData, int chargeAmount) {
        WaterChecks checks = this.checkSteadyNormalFastPush(player);
        if (player.m_20202_() != null) {
            player.m_5661_((Component)Component.m_237110_((String)"jutsu.fail.riding", (Object[])new Object[]{Component.m_237115_((String)"jutsu.waterwalk").m_130940_(ChatFormatting.YELLOW)}), true);
            return false;
        }
        float fullCost = 0.0f;
        if (checks.pushUpFast) {
            fullCost += 1.0f;
        } else if (checks.steadyCheck) {
            fullCost += 0.12f;
        }
        if (ninjaData.getChakra() < fullCost) {
            player.m_5661_((Component)Component.m_237110_((String)"jutsu.fail.notenoughchakra", (Object[])new Object[]{Component.m_237115_((String)"jutsu.waterwalk").m_130940_(ChatFormatting.YELLOW)}), true);
            return false;
        }
        ninjaData.useChakra(fullCost, 15);
        return true;
    }

    @Override
    public SoundEvent castingSound() {
        return null;
    }

    public WaterChecks checkSteadyNormalFastPush(Player player) {
        int blockX = (int)Math.floor(player.m_20185_());
        int blockZ = (int)Math.floor(player.m_20189_());
        int block1 = (int)Math.round(player.m_20186_() - (double)0.56f);
        boolean steadyCheck = this.triggerWaterWalk(player.f_19853_, new BlockPos(blockX, block1, blockZ));
        int block2 = (int)Math.round(player.m_20186_());
        int beforeBlock2 = (int)Math.round(player.f_19855_);
        boolean pushUpFast = this.triggerWaterWalk(player.f_19853_, new BlockPos(blockX, block2, blockZ));
        if (player.f_19853_.m_5776_() && player.f_19855_ > player.m_20186_()) {
            boolean beforeYCheck = this.triggerWaterWalk(player.f_19853_, new BlockPos(blockX, beforeBlock2, blockZ));
            if (!beforeYCheck && steadyCheck && player.f_19855_ - player.m_20186_() < (double)0.9f) {
                Vec3 vec = player.m_20184_();
                player.m_6001_(vec.m_7096_(), 0.0, vec.m_7094_());
                player.m_6034_(player.m_20185_(), (double)((float)block2 + 0.05f), player.m_20189_());
            } else {
                steadyCheck = false;
            }
        }
        int block3 = (int)Math.round(player.m_20186_() - (double)0.47f);
        boolean pushUpNormal = this.triggerWaterWalk(player.f_19853_, new BlockPos(blockX, block3, blockZ));
        return new WaterChecks(steadyCheck, pushUpFast, pushUpNormal);
    }

    private void updatePlayerMovement(Player player, INinjaData ninjaData) {
        WaterChecks checks = this.checkSteadyNormalFastPush(player);
        Vec3 vec = player.m_20184_();
        double resultingYSpeed = vec.m_7098_();
        if (checks.pushUpFast) {
            if ((resultingYSpeed += 0.2) > 0.6) {
                resultingYSpeed = 0.6;
            }
        } else if (checks.pushUpNormal) {
            if ((resultingYSpeed += 0.1) > 0.2) {
                resultingYSpeed = 0.2;
            }
        } else if (checks.steadyCheck && resultingYSpeed < 0.0) {
            resultingYSpeed = 0.0;
            player.m_183634_();
            player.m_6853_(true);
            ninjaData.getDoubleJumpData().canDoubleJumpServer = true;
            if (player.m_21255_()) {
                player.m_36321_();
            }
            float f = (float)Math.min(0.1, player.m_20184_().m_165924_());
            player.f_36100_ += (f - player.f_36100_) * 0.4f;
        }
        player.m_6001_(vec.m_7096_(), resultingYSpeed, vec.m_7094_());
    }

    public boolean triggerWaterWalk(Level level, BlockPos blockPos) {
        FluidState fluidState = level.m_6425_(blockPos);
        BlockState blockState = level.m_8055_(blockPos);
        return (fluidState.m_192917_((Fluid)Fluids.f_76193_) || fluidState.m_192917_((Fluid)Fluids.f_76192_)) && !blockState.m_60767_().m_76334_();
    }

    @Override
    public void performServer(Player player, INinjaData ninjaData, int ticksActive) {
        this.updatePlayerMovement(player, ninjaData);
    }

    @Override
    public void performToggleClient(Player player, INinjaData ninjaData) {
        this.updatePlayerMovement(player, ninjaData);
    }

    public record WaterChecks(boolean steadyCheck, boolean pushUpFast, boolean pushUpNormal) {
    }
}

