/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.block.weapons;

import com.sekwah.narutomod.block.NarutoBlockStates;
import com.sekwah.narutomod.entity.item.PaperBombEntity;
import com.sekwah.narutomod.sounds.NarutoSounds;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class PaperBombBlock
extends FaceAttachedHorizontalDirectionalBlock {
    public static final BooleanProperty HIDDEN = NarutoBlockStates.HIDDEN;
    protected static final double HEIGHT = 2.0;
    protected static final double LENGTH = 8.0;
    protected static final double WIDTH = 6.0;
    protected static final int TRANSPARENT_DELAY = 100;
    protected static final VoxelShape AABB_CEILING_X = Block.m_49796_((double)4.0, (double)14.0, (double)5.0, (double)12.0, (double)16.0, (double)11.0);
    protected static final VoxelShape AABB_CEILING_Z = Block.m_49796_((double)5.0, (double)14.0, (double)4.0, (double)11.0, (double)16.0, (double)12.0);
    protected static final VoxelShape AABB_FLOOR_X = Block.m_49796_((double)4.0, (double)0.0, (double)5.0, (double)12.0, (double)2.0, (double)11.0);
    protected static final VoxelShape AABB_FLOOR_Z = Block.m_49796_((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)2.0, (double)12.0);
    protected static final VoxelShape AABB_NORTH = Block.m_49796_((double)5.0, (double)4.0, (double)14.0, (double)11.0, (double)12.0, (double)16.0);
    protected static final VoxelShape AABB_SOUTH = Block.m_49796_((double)5.0, (double)4.0, (double)0.0, (double)11.0, (double)12.0, (double)2.0);
    protected static final VoxelShape AABB_WEST = Block.m_49796_((double)14.0, (double)4.0, (double)5.0, (double)16.0, (double)12.0, (double)11.0);
    protected static final VoxelShape AABB_EAST = Block.m_49796_((double)0.0, (double)4.0, (double)5.0, (double)2.0, (double)12.0, (double)11.0);

    public PaperBombBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)HIDDEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_53179_, (Comparable)AttachFace.FLOOR));
    }

    public void m_7592_(Level levelIn, BlockPos pos, Explosion explosionIn) {
        this.spawnPaperbomb(null, levelIn, pos, explosionIn.m_252906_(), true);
    }

    public boolean isFlammable(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return true;
    }

    public int getFlammability(BlockState state, BlockGetter world, BlockPos pos, Direction face) {
        return 100;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        Direction direction = (Direction)state.m_61143_((Property)f_54117_);
        switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                if (direction.m_122434_() == Direction.Axis.X) {
                    return AABB_FLOOR_X;
                }
                return AABB_FLOOR_Z;
            }
            case WALL: {
                switch (direction) {
                    case EAST: {
                        return AABB_EAST;
                    }
                    case WEST: {
                        return AABB_WEST;
                    }
                    case SOUTH: {
                        return AABB_SOUTH;
                    }
                }
                return AABB_NORTH;
            }
        }
        if (direction.m_122434_() == Direction.Axis.X) {
            return AABB_CEILING_X;
        }
        return AABB_CEILING_Z;
    }

    public void m_214162_(BlockState state, Level worldIn, BlockPos pos, RandomSource rand) {
        if (!((Boolean)state.m_61143_((Property)HIDDEN)).booleanValue()) {
            worldIn.m_7731_(pos, (BlockState)state.m_61124_((Property)HIDDEN, (Comparable)Boolean.TRUE), 3);
        }
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (worldIn.m_46753_(pos)) {
            this.onCaughtFire(state, worldIn, pos, null, null);
            worldIn.m_7471_(pos, false);
        }
    }

    public void m_6807_(BlockState state, Level worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.m_6807_(state, worldIn, pos, oldState, isMoving);
        worldIn.m_186460_(new BlockPos((Vec3i)pos), (Block)this, 100);
    }

    public void onCaughtFire(BlockState state, Level worldIn, BlockPos pos, @Nullable Direction face, @Nullable LivingEntity igniter) {
        this.spawnPaperbomb(state, worldIn, pos, igniter);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (!worldIn.f_46443_) {
            this.spawnPaperbomb(state, worldIn, pos, (LivingEntity)player);
            worldIn.m_7471_(pos, false);
        }
        return InteractionResult.m_19078_((boolean)worldIn.f_46443_);
    }

    public void m_7892_(BlockState state, Level worldIn, BlockPos pos, Entity entityIn) {
        if (!worldIn.f_46443_) {
            this.spawnPaperbomb(state, worldIn, pos, entityIn instanceof LivingEntity ? (LivingEntity)entityIn : null, true);
            worldIn.m_7471_(pos, false);
        }
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_, HIDDEN, f_53179_});
    }

    public void spawnPaperbomb(@Nullable BlockState state, Level worldIn, BlockPos pos, @Nullable LivingEntity igniter) {
        this.spawnPaperbomb(state, worldIn, pos, igniter, false);
    }

    public void m_141997_(BlockState blockState, Level level, BlockPos pos, Biome.Precipitation precipitation) {
        if (precipitation == Biome.Precipitation.RAIN && level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            level.m_46961_(pos, true);
        }
    }

    public void spawnPaperbomb(@Nullable BlockState state, Level worldIn, BlockPos pos, @Nullable LivingEntity igniter, boolean shortFuse) {
        if (!worldIn.f_46443_) {
            BlockPos attachBlock;
            Direction dir = state != null ? (Direction)state.m_61143_((Property)f_54117_) : Direction.NORTH;
            Vec3i dirVec = dir.m_122436_();
            AttachFace face = state != null ? (AttachFace)state.m_61143_((Property)f_53179_) : AttachFace.FLOOR;
            double xOffset = 0.5;
            double yOffset = 0.0;
            double zOffset = 0.5;
            if (face.equals((Object)AttachFace.CEILING)) {
                yOffset += 0.5;
                attachBlock = pos.m_7494_();
            } else if (face.equals((Object)AttachFace.WALL)) {
                attachBlock = pos.m_121996_(dirVec);
                yOffset += 0.25;
                xOffset -= 0.25 * (double)dirVec.m_123341_();
                zOffset -= 0.25 * (double)dirVec.m_123343_();
            } else {
                attachBlock = pos.m_7495_();
            }
            PaperBombEntity paperBombEntity = new PaperBombEntity(worldIn, (double)pos.m_123341_() + xOffset, (double)pos.m_123342_() + yOffset, (double)pos.m_123343_() + zOffset, igniter, dir, face, attachBlock);
            worldIn.m_7967_((Entity)paperBombEntity);
            if (shortFuse) {
                paperBombEntity.setFuse((short)(paperBombEntity.getFuse() / 32));
            } else {
                worldIn.m_6263_(null, paperBombEntity.m_20185_(), paperBombEntity.m_20186_(), paperBombEntity.m_20189_(), (SoundEvent)NarutoSounds.SIZZLE.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }
}

