/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.capabilities;

import com.sekwah.narutomod.abilities.Ability;
import com.sekwah.narutomod.capabilities.INinjaData;
import com.sekwah.narutomod.capabilities.NinjaData;
import com.sekwah.narutomod.registries.NarutoRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="narutomod")
public class NinjaCapabilityHandler {
    public static final Capability<INinjaData> NINJA_DATA = CapabilityManager.get((CapabilityToken)new CapabilityToken<INinjaData>(){});

    @SubscribeEvent
    public static void attachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player) {
            event.addCapability(new ResourceLocation("narutomod", "ninja_data"), (ICapabilityProvider)new NinjaData(!((Entity)event.getObject()).f_19853_.f_46443_));
        }
    }

    @SubscribeEvent
    public static void onPlayerUpdate(TickEvent.PlayerTickEvent event) {
        if (event.phase.equals((Object)TickEvent.Phase.END)) {
            Player player = event.player;
            player.getCapability(NINJA_DATA).ifPresent(data -> {
                if (event.side.isServer()) {
                    if (player.m_7500_()) {
                        data.setChakra(data.getMaxChakra());
                        data.setStamina(data.getMaxStamina());
                    }
                    data.updateDataServer(player);
                    if (!player.m_5833_()) {
                        data.getToggleAbilityData().getAbilitiesHashSet().forEach(abilityName -> {
                            Ability ability = (Ability)NarutoRegistries.ABILITIES.getValue(abilityName);
                            if (ability.handleCost(player, (INinjaData)data)) {
                                ability.performServer(player, (INinjaData)data);
                            } else {
                                data.getToggleAbilityData().removeAbilityEnded(player, (INinjaData)data, ability);
                            }
                        });
                    }
                } else {
                    data.updateDataClient(player);
                    if (!player.m_5833_()) {
                        data.getToggleAbilityData().getAbilitiesHashSet().forEach(abilityName -> {
                            Ability ability = (Ability)NarutoRegistries.ABILITIES.getValue(abilityName);
                            if (ability instanceof Ability.Toggled) {
                                Ability.Toggled toggleAbility = (Ability.Toggled)((Object)ability);
                                toggleAbility.performToggleClient(player, (INinjaData)data);
                            }
                        });
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerClone(PlayerEvent.Clone event) {
        event.getOriginal().reviveCaps();
        event.getOriginal().getCapability(NINJA_DATA).ifPresent(original -> event.getEntity().getCapability(NINJA_DATA).ifPresent(future -> future.deserializeNBT(original.serializeNBT())));
    }
}

