/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.capabilities;

import com.mojang.logging.LogUtils;
import com.sekwah.narutomod.abilities.Ability;
import com.sekwah.narutomod.capabilities.CooldownTickEvent;
import com.sekwah.narutomod.capabilities.DelayedPlayerTickEvent;
import com.sekwah.narutomod.capabilities.DoubleJumpData;
import com.sekwah.narutomod.capabilities.INinjaData;
import com.sekwah.narutomod.capabilities.NinjaCapabilityHandler;
import com.sekwah.narutomod.capabilities.toggleabilitydata.ToggleAbilityData;
import com.sekwah.narutomod.config.NarutoConfig;
import com.sekwah.narutomod.gameevents.NarutoGameEvents;
import com.sekwah.narutomod.registries.NarutoRegistries;
import com.sekwah.sekclib.capabilitysync.capabilitysync.annotation.Sync;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import org.slf4j.Logger;

public class NinjaData
implements INinjaData,
ICapabilityProvider {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Sync(minTicks=1)
    private float chakra;
    @Sync(minTicks=1)
    private float stamina;
    @Sync(minTicks=1)
    private float substitutions;
    @Sync
    private float maxChakra;
    @Sync(syncGlobally=true)
    private boolean ninjaModeEnabled;
    @Sync
    private float maxStamina;
    private float maxSubstitutions;
    @Sync
    private Vec3 substitutionLocation;
    @Sync
    private ResourceLocation substitutionDimension;
    @Sync(minTicks=1)
    private DoubleJumpData doubleJumpData;
    private boolean doubleJumpReady;
    @Sync(minTicks=1)
    private ResourceLocation currentlyChanneled;
    @Sync(minTicks=1)
    private int ticksChanneled;
    @Sync
    private ToggleAbilityData toggleAbilityData;
    @Sync(minTicks=1, syncGlobally=true)
    private boolean isInvisible = false;
    private int invisibleTicks = 0;
    private ArrayList<DelayedPlayerTickEvent> delayedTickEvents = new ArrayList();
    private HashMap<String, CooldownTickEvent> cooldownTickEvents = new HashMap();
    private final RegenInfo chakraRegenInfo = new RegenInfo();
    private final RegenInfo staminaRegenInfo = new RegenInfo();
    private static final String CHAKRA_TAG = "chakra";
    private static final String STAMINA_TAG = "stamina";
    private static final String NINJA_MODE_ENABLED = "ninjaModeEnabled";
    private static final String SAVE_TIME = "save_time";
    private static final String COOLDOWN_TAG = "cooldowns";
    private static final String SUBSTITUTION_TAG = "substitutions";
    private final LazyOptional<INinjaData> holder = LazyOptional.of(() -> this);

    public NinjaData(boolean isServer) {
        if (isServer) {
            this.getConfigData();
            this.stamina = this.maxChakra;
            this.chakra = this.maxStamina;
        }
        this.toggleAbilityData = new ToggleAbilityData();
        this.doubleJumpData = new DoubleJumpData(false);
    }

    @Override
    public float getChakra() {
        return this.chakra;
    }

    @Override
    public float getMaxChakra() {
        return this.maxChakra;
    }

    @Override
    public float getStamina() {
        return this.stamina;
    }

    @Override
    public float getSubstitutionCount() {
        return this.substitutions;
    }

    @Override
    public float getMaxStamina() {
        return this.maxStamina;
    }

    @Override
    public void setChakra(float chakra) {
        this.chakra = chakra;
    }

    @Override
    public void setStamina(float stamina) {
        this.stamina = stamina;
    }

    @Override
    public void useChakra(float amount, int cooldown) {
        this.chakra -= amount;
        this.chakraRegenInfo.cooldown = Math.max(cooldown, this.chakraRegenInfo.cooldown);
    }

    @Override
    public void useStamina(float amount, int cooldown) {
        this.stamina -= amount;
        this.staminaRegenInfo.cooldown = Math.max(cooldown, this.staminaRegenInfo.cooldown);
    }

    @Override
    public void useSubstitution(float amount) {
        this.substitutions -= amount;
    }

    @Override
    public void addChakra(float amount) {
        this.chakra = Math.min(Math.max(this.chakra + amount, 0.0f), this.maxChakra);
    }

    @Override
    public void addStamina(float amount) {
        this.stamina = Math.min(Math.max(this.stamina + amount, 0.0f), this.maxStamina);
    }

    @Override
    public void setInvisibleTicks(int ticks) {
        this.invisibleTicks = ticks;
    }

    @Override
    public boolean getInvisible() {
        return this.isInvisible;
    }

    @Override
    public Vec3 getSubstitutionLoc() {
        return this.substitutionLocation;
    }

    @Override
    public ResourceLocation getSubstitutionDimension() {
        return this.substitutionDimension;
    }

    @Override
    public void setSubstitutionLoc(Vec3 loc, ResourceLocation dimension) {
        this.substitutionLocation = loc;
        this.substitutionDimension = dimension;
    }

    @Override
    public DoubleJumpData getDoubleJumpData() {
        return this.doubleJumpData;
    }

    @Override
    public ResourceLocation getCurrentlyChanneledAbility() {
        return this.currentlyChanneled;
    }

    @Override
    public int getCurrentlyChanneledTicks() {
        return this.ticksChanneled;
    }

    @Override
    public void setCurrentlyChanneledAbility(Player player, Ability ability) {
        if (ability != null) {
            Ability.Channeled channeled;
            if (ability.castingSound() != null) {
                player.m_9236_().m_6269_(null, (Entity)player, ability.castingSound(), SoundSource.PLAYERS, 0.5f, 1.0f);
                player.m_9236_().m_220400_((Entity)player, (GameEvent)NarutoGameEvents.JUTSU_CASTING.get(), player.m_20182_().m_82520_(0.0, (double)player.m_20192_() * 0.7, 0.0));
            }
            if (!(ability instanceof Ability.Channeled) || !(channeled = (Ability.Channeled)((Object)ability)).hideChannelMessages()) {
                Ability.Channeled channeled2;
                if (ability instanceof Ability.Channeled && (channeled2 = (Ability.Channeled)((Object)ability)).useChargedMessages()) {
                    player.m_5661_((Component)Component.m_237110_((String)"jutsu.charge.start", (Object[])new Object[]{Component.m_237115_((String)ability.getTranslationKey(this, 1)).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GREEN), true);
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"jutsu.channel.start", (Object[])new Object[]{Component.m_237115_((String)ability.getTranslationKey(this, 1)).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GREEN), true);
                }
            }
            NarutoRegistries.ABILITIES.getResourceKey((Object)ability).ifPresent(abilityResourceKey -> {
                this.currentlyChanneled = abilityResourceKey.m_135782_();
            });
        } else {
            Ability.Channeled channeled;
            Ability currentAbility;
            if (!(this.currentlyChanneled == null || (currentAbility = (Ability)NarutoRegistries.ABILITIES.getValue(this.currentlyChanneled)) == null || currentAbility instanceof Ability.Channeled && (channeled = (Ability.Channeled)((Object)currentAbility)).hideChannelMessages())) {
                Ability.Channeled channeled3;
                if (currentAbility instanceof Ability.Channeled && (channeled3 = (Ability.Channeled)((Object)currentAbility)).useChargedMessages()) {
                    player.m_5661_((Component)Component.m_237110_((String)"jutsu.cast", (Object[])new Object[]{Component.m_237115_((String)currentAbility.getTranslationKey(this, this.ticksChanneled - 1)).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GREEN), true);
                } else {
                    player.m_5661_((Component)Component.m_237110_((String)"jutsu.channel.stop", (Object[])new Object[]{Component.m_237115_((String)currentAbility.getTranslationKey(this)).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.RED), true);
                }
            }
            this.currentlyChanneled = null;
        }
        this.ticksChanneled = 0;
    }

    @Override
    public ToggleAbilityData getToggleAbilityData() {
        return this.toggleAbilityData;
    }

    @Override
    public void updateDataServer(Player player) {
        if (this.invisibleTicks > 0) {
            --this.invisibleTicks;
            this.isInvisible = true;
        } else {
            this.isInvisible = false;
        }
        if (!this.isNinjaModeEnabled()) {
            return;
        }
        this.getConfigData();
        Iterator<DelayedPlayerTickEvent> iterator = this.delayedTickEvents.iterator();
        while (iterator.hasNext()) {
            DelayedPlayerTickEvent event = iterator.next();
            event.tick();
            if (!event.shouldRun()) continue;
            event.run(player);
            iterator.remove();
        }
        ArrayList<String> completeList = new ArrayList<String>(this.cooldownTickEvents.keySet());
        for (String name : completeList) {
            CooldownTickEvent event = this.cooldownTickEvents.get(name);
            event.tick();
            if (!event.isComplete()) continue;
            this.cooldownTickEvents.remove(name);
        }
        if (this.staminaRegenInfo.canRegen()) {
            this.stamina += NarutoConfig.staminaRegen;
        }
        if (this.chakraRegenInfo.canRegen()) {
            this.chakra += NarutoConfig.chakraRegen;
        }
        this.substitutions += NarutoConfig.substitutionRegenRate;
        this.substitutions = Math.min(Math.max(this.substitutions, 0.0f), this.maxSubstitutions);
        this.stamina = Math.min(Math.max(this.stamina, 0.0f), this.maxStamina);
        this.chakra = Math.min(Math.max(this.chakra, 0.0f), this.maxChakra);
        if (this.currentlyChanneled != null) {
            Ability ability = (Ability)NarutoRegistries.ABILITIES.getValue(this.currentlyChanneled);
            if (ability != null && ability.activationType() == Ability.ActivationType.CHANNELED) {
                if (ability.handleCost(player, this, this.ticksChanneled)) {
                    if (ability instanceof Ability.Channeled) {
                        Ability.Channeled channeled = (Ability.Channeled)((Object)ability);
                        channeled.handleChannelling(player, this, this.ticksChanneled);
                    }
                } else if (this.ticksChanneled > 0) {
                    int finalTicksChanneled = this.ticksChanneled - 1;
                    ability.performServer(player, this, finalTicksChanneled);
                    this.setCurrentlyChanneledAbility(player, null);
                }
            } else {
                LOGGER.error("Somehow non channeled ability has been set to ninja data {}", (Object)this.currentlyChanneled);
            }
            ++this.ticksChanneled;
        }
        if (player.m_20096_()) {
            this.doubleJumpData.canDoubleJumpServer = true;
        }
    }

    private void getConfigData() {
        this.maxChakra = NarutoConfig.maxChakra;
        this.maxStamina = NarutoConfig.maxStamina;
        this.maxSubstitutions = NarutoConfig.maxSubstitutions;
    }

    @Override
    public void scheduleDelayedTickEvent(Consumer<Player> consumer, int tickDelay) {
        this.delayedTickEvents.add(new DelayedPlayerTickEvent(consumer, tickDelay));
    }

    @Override
    public void updateDataClient(Player player) {
        this.doubleJumpData.stuckCheck();
    }

    @Override
    public void setIsNinja(boolean enableNinja) {
        this.ninjaModeEnabled = enableNinja;
    }

    @Override
    public boolean isNinjaModeEnabled() {
        return this.ninjaModeEnabled;
    }

    public Tag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128350_(CHAKRA_TAG, this.chakra);
        nbt.m_128350_(STAMINA_TAG, this.stamina);
        nbt.m_128379_(NINJA_MODE_ENABLED, this.ninjaModeEnabled);
        long currentTime = System.currentTimeMillis();
        nbt.m_128356_(SAVE_TIME, currentTime);
        CompoundTag cooldownData = new CompoundTag();
        for (String key : this.cooldownTickEvents.keySet()) {
            CooldownTickEvent event = this.cooldownTickEvents.get(key);
            cooldownData.m_128405_(key, event.ticks);
        }
        nbt.m_128365_(COOLDOWN_TAG, (Tag)cooldownData);
        nbt.m_128350_(SUBSTITUTION_TAG, this.substitutions);
        return nbt;
    }

    public void deserializeNBT(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            long currentTime = System.currentTimeMillis();
            long saveTime = compoundTag.m_128454_(SAVE_TIME);
            int ticksPassed = Math.max((int)((currentTime - saveTime) / 1000L * 20L), 0);
            this.chakra = compoundTag.m_128457_(CHAKRA_TAG);
            this.stamina = compoundTag.m_128457_(STAMINA_TAG);
            this.ninjaModeEnabled = compoundTag.m_128471_(NINJA_MODE_ENABLED);
            CompoundTag cooldownData = compoundTag.m_128469_(COOLDOWN_TAG);
            for (String key : cooldownData.m_128431_()) {
                this.cooldownTickEvents.put(key, new CooldownTickEvent(cooldownData.m_128451_(key) - ticksPassed));
            }
            this.substitutions = compoundTag.m_128457_(SUBSTITUTION_TAG);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return NinjaCapabilityHandler.NINJA_DATA.orEmpty(cap, this.holder);
    }

    @Override
    public HashMap<String, CooldownTickEvent> getCooldownEvents() {
        return this.cooldownTickEvents;
    }

    static class RegenInfo {
        public int cooldown;

        public boolean canRegen() {
            if (this.cooldown > 0) {
                --this.cooldown;
                return false;
            }
            return true;
        }
    }
}

