/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.capabilities.lingerabilitydata;

import com.sekwah.narutomod.abilities.Ability;
import com.sekwah.narutomod.capabilities.INinjaData;
import com.sekwah.narutomod.registries.NarutoRegistries;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class LingerAbilityData {
    private final HashSet<ResourceLocation> abilities;

    public LingerAbilityData(int size) {
        this.abilities = new HashSet(size);
    }

    public LingerAbilityData() {
        this.abilities = new HashSet();
    }

    public boolean addAbility(Ability ability) {
        Optional abilityKey = NarutoRegistries.ABILITIES.getResourceKey((Object)ability);
        return abilityKey.filter(abilityResourceKey -> this.abilities.add(abilityResourceKey.m_135782_())).isPresent();
    }

    public boolean addAbilityStarted(Player player, INinjaData ninjaData, Ability ability) {
        if (ability.activationType() == Ability.ActivationType.TOGGLE && ability.logInChat()) {
            player.m_5661_((Component)Component.m_237110_((String)"jutsu.toggle.enabled", (Object[])new Object[]{Component.m_237115_((String)ability.getTranslationKey(ninjaData)).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GREEN), true);
        }
        return this.addAbility(ability);
    }

    public boolean removeAbilityEnded(Player player, INinjaData ninjaData, Ability ability) {
        if (ability instanceof Ability.HandleEnded) {
            Ability.HandleEnded endedAbility = (Ability.HandleEnded)((Object)ability);
            endedAbility.handleAbilityEnded(player, ninjaData, 0);
        }
        if (ability.activationType() == Ability.ActivationType.TOGGLE && ability.logInChat()) {
            player.m_5661_((Component)Component.m_237110_((String)"jutsu.toggle.disabled", (Object[])new Object[]{Component.m_237115_((String)ability.getTranslationKey(ninjaData)).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.RED), true);
        }
        return this.removeAbility(ability);
    }

    public boolean removeAbility(Ability ability) {
        Optional resourceKey = NarutoRegistries.ABILITIES.getResourceKey((Object)ability);
        return resourceKey.filter(abilityResourceKey -> this.abilities.remove(abilityResourceKey.m_135782_())).isPresent();
    }

    public HashSet<ResourceLocation> getAbilitiesHashSet() {
        return this.abilities;
    }

    public int hashCode() {
        return Objects.hash(this.abilities);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LingerAbilityData)) {
            return false;
        }
        LingerAbilityData that = (LingerAbilityData)o;
        return this.abilities.equals(that.abilities);
    }
}

