/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.capabilities.toggleabilitydata;

import com.sekwah.narutomod.abilities.Ability;
import com.sekwah.narutomod.capabilities.INinjaData;
import com.sekwah.narutomod.registries.NarutoRegistries;
import java.util.HashSet;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class ToggleAbilityData {
    private final HashSet<ResourceLocation> abilities;

    public ToggleAbilityData(int size) {
        this.abilities = new HashSet(size);
    }

    public ToggleAbilityData() {
        this.abilities = new HashSet();
    }

    public boolean addAbility(ResourceLocation ability) {
        return this.abilities.add(ability);
    }

    public boolean addAbilityStarted(Player player, INinjaData ninjaData, Ability ability) {
        ResourceKey registryName;
        if (ability.activationType() == Ability.ActivationType.TOGGLE && ability.logInChat()) {
            player.m_5661_((Component)Component.m_237110_((String)"jutsu.toggle.enabled", (Object[])new Object[]{Component.m_237115_((String)ability.getTranslationKey(ninjaData)).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GREEN), true);
        }
        if ((registryName = (ResourceKey)NarutoRegistries.ABILITIES.getResourceKey((Object)ability).orElse(null)) != null) {
            return this.addAbility(registryName.m_135782_());
        }
        return false;
    }

    public boolean removeAbilityEnded(Player player, INinjaData ninjaData, Ability ability) {
        ResourceKey registryName;
        if (ability instanceof Ability.HandleEnded) {
            Ability.HandleEnded endedAbility = (Ability.HandleEnded)((Object)ability);
            endedAbility.handleAbilityEnded(player, ninjaData, 0);
        }
        if (ability.activationType() == Ability.ActivationType.TOGGLE && ability.logInChat()) {
            player.m_5661_((Component)Component.m_237110_((String)"jutsu.toggle.disabled", (Object[])new Object[]{Component.m_237115_((String)ability.getTranslationKey(ninjaData)).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.RED), true);
        }
        if ((registryName = (ResourceKey)NarutoRegistries.ABILITIES.getResourceKey((Object)ability).orElse(null)) != null) {
            return this.removeAbility(registryName.m_135782_());
        }
        return false;
    }

    public boolean removeAbility(ResourceLocation ability) {
        return this.abilities.remove(ability);
    }

    public HashSet<ResourceLocation> getAbilitiesHashSet() {
        return this.abilities;
    }

    public int hashCode() {
        return Objects.hash(this.abilities);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ToggleAbilityData)) {
            return false;
        }
        ToggleAbilityData that = (ToggleAbilityData)o;
        return this.abilities.equals(that.abilities);
    }
}

