/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sekwah.narutomod.capabilities.NinjaCapabilityHandler;
import com.sekwah.narutomod.client.gui.BarDesigns;
import com.sekwah.narutomod.client.gui.PlayerGUI;
import com.sekwah.narutomod.config.NarutoConfig;
import com.sekwah.narutomod.util.ColorUtil;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class ChakraAndStaminaGUI
extends GuiComponent
implements PlayerGUI {
    public static final BarDesigns.BarInfo[] barTypes = BarDesigns.BarInfo.values();
    private final Minecraft minecraft;
    private int screenWidth;
    private int screenHeight;
    private float chakra;
    private float stamina;
    private float maxChakra;
    private float maxStamina;

    public ChakraAndStaminaGUI(Minecraft mc) {
        this.minecraft = mc;
    }

    @Override
    public void render(PoseStack matrixStack, Matrix4f worldMatrix, Vec3 cameraPos) {
        this.screenWidth = this.minecraft.m_91268_().m_85445_();
        this.screenHeight = this.minecraft.m_91268_().m_85446_();
        int barDesign = NarutoConfig.chakraBarDesign;
        float currentChakraPercent = this.maxChakra > 0.0f ? this.chakra / this.maxChakra : 0.0f;
        float currentStaminaPercent = this.maxStamina > 0.0f ? this.stamina / this.maxStamina : 0.0f;
        int width = 100;
        int offset = 128;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ChakraAndStaminaGUI.barTypes[barDesign].texture);
        int barWidth = ChakraAndStaminaGUI.barTypes[barDesign].width;
        int xOffset = ChakraAndStaminaGUI.barTypes[barDesign].offset;
        int valuesOffset = 128 + barWidth / 2;
        int valuesHeight = 26;
        int screenMid = this.screenWidth / 2;
        float darkenFactor = 0.25f;
        Color chakraColor = new Color(20, 179, 255);
        Color staminaColor = new Color(0, 255, 0);
        int intStaminaColor = ColorUtil.toMCColor(staminaColor).m_131265_();
        int intChakraColor = ColorUtil.toMCColor(chakraColor).m_131265_();
        int intStaminaColorDarker = ColorUtil.toMCColor(new Color((int)((float)staminaColor.getRed() * darkenFactor), (int)((float)staminaColor.getGreen() * darkenFactor), (int)((float)staminaColor.getBlue() * darkenFactor))).m_131265_();
        int intChakraColorDarker = ColorUtil.toMCColor(new Color((int)((float)chakraColor.getRed() * darkenFactor), (int)((float)chakraColor.getGreen() * darkenFactor), (int)((float)chakraColor.getBlue() * darkenFactor))).m_131265_();
        int chakraWidth = (int)((float)barWidth * currentChakraPercent);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        ChakraAndStaminaGUI.m_93133_((PoseStack)matrixStack, (int)(screenMid - width - offset), (int)(this.screenHeight - 22), (float)0.0f, (float)22.0f, (int)width, (int)22, (int)width, (int)44);
        int staminaWidth = (int)((float)barWidth * currentStaminaPercent);
        ChakraAndStaminaGUI.m_93133_((PoseStack)matrixStack, (int)(screenMid + offset), (int)(this.screenHeight - 22), (float)0.0f, (float)22.0f, (int)width, (int)22, (int)(-width), (int)44);
        this.setColor(chakraColor);
        ChakraAndStaminaGUI.m_93133_((PoseStack)matrixStack, (int)(screenMid - chakraWidth - offset - (width - xOffset - barWidth)), (int)(this.screenHeight - 22), (float)(xOffset + (barWidth - chakraWidth)), (float)0.0f, (int)chakraWidth, (int)22, (int)width, (int)44);
        this.setColor(staminaColor);
        ChakraAndStaminaGUI.m_93133_((PoseStack)matrixStack, (int)(screenMid + offset + (100 - barWidth - xOffset)), (int)(this.screenHeight - 22), (float)(-barWidth - xOffset), (float)0.0f, (int)staminaWidth, (int)22, (int)(-width), (int)44);
        String chakraText = (int)this.chakra + "/" + (int)this.maxChakra;
        this.centeredTextOutlined(matrixStack, chakraText, screenMid - valuesOffset, this.screenHeight - valuesHeight, intChakraColor, intChakraColorDarker);
        String staminaText = (int)this.stamina + "/" + (int)this.maxStamina;
        this.centeredTextOutlined(matrixStack, staminaText, screenMid + valuesOffset, this.screenHeight - valuesHeight, intStaminaColor, intStaminaColorDarker);
    }

    private void centeredTextOutlined(PoseStack matrixStack, String text, int x, int y, int color, int backgroundColor) {
        int width = this.getFont().m_92895_(text) / 2;
        this.getFont().m_92883_(matrixStack, text, (float)x + 1.0f - (float)width, (float)y, backgroundColor);
        this.getFont().m_92883_(matrixStack, text, (float)x - 1.0f - (float)width, (float)y, backgroundColor);
        this.getFont().m_92883_(matrixStack, text, (float)x - (float)width, (float)y + 1.0f, backgroundColor);
        this.getFont().m_92883_(matrixStack, text, (float)x - (float)width, (float)y - 1.0f, backgroundColor);
        this.getFont().m_92883_(matrixStack, text, (float)x - (float)width, (float)y, color);
    }

    @Override
    public void tick(Player player) {
        player.getCapability(NinjaCapabilityHandler.NINJA_DATA).ifPresent(ninjaData -> {
            this.chakra = ninjaData.getChakra();
            this.stamina = ninjaData.getStamina();
            this.maxChakra = ninjaData.getMaxChakra();
            this.maxStamina = ninjaData.getMaxStamina();
        });
    }

    private void setColor(Color color) {
        RenderSystem.m_157429_((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
    }

    private Font getFont() {
        return this.minecraft.f_91062_;
    }
}

