/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.sekwah.narutomod.capabilities.NinjaCapabilityHandler;
import com.sekwah.narutomod.client.gui.ChakraAndStaminaGUI;
import com.sekwah.narutomod.client.gui.PlayerGUI;
import com.sekwah.narutomod.client.gui.SubstitutionGUI;
import com.sekwah.narutomod.client.gui.WorldMarkerGUI;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class NarutoInGameGUI {
    private final ChakraAndStaminaGUI charkaOverlay;
    private final SubstitutionGUI substitutionOverlay;
    private final WorldMarkerGUI worldMarkerOverlay;
    private final Minecraft minecraft = Minecraft.m_91087_();
    private final PlayerGUI[] overlays;
    private boolean shouldRender;
    private static Matrix4f worldMatrix;
    private static Vec3 cameraPos;

    public NarutoInGameGUI() {
        this.charkaOverlay = new ChakraAndStaminaGUI(this.minecraft);
        this.substitutionOverlay = new SubstitutionGUI(this.minecraft);
        this.worldMarkerOverlay = new WorldMarkerGUI(this.minecraft);
        this.overlays = new PlayerGUI[]{this.worldMarkerOverlay, this.substitutionOverlay, this.charkaOverlay};
        MinecraftForge.EVENT_BUS.addListener(this::renderGameOverlay);
        MinecraftForge.EVENT_BUS.addListener(this::clientTickEvent);
        MinecraftForge.EVENT_BUS.addListener(this::renderLevelLast);
    }

    public static void registerEvents() {
    }

    @SubscribeEvent
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
        PlayerGUI[] playerGUIArray = this.minecraft.m_91288_();
        if (playerGUIArray instanceof Player) {
            Player player = (Player)playerGUIArray;
            player.getCapability(NinjaCapabilityHandler.NINJA_DATA).ifPresent(ninjaData -> {
                this.shouldRender = ninjaData.isNinjaModeEnabled();
            });
            for (PlayerGUI overlay : this.overlays) {
                overlay.tick(player);
            }
        } else {
            this.shouldRender = false;
        }
    }

    @SubscribeEvent
    public void renderGameOverlay(RenderGuiOverlayEvent.Pre event) {
        if (event.getOverlay() != VanillaGuiOverlay.HOTBAR.type()) {
            return;
        }
        if (!this.shouldRender) {
            return;
        }
        PoseStack stack = event.getPoseStack();
        for (PlayerGUI overlay : this.overlays) {
            overlay.render(stack, worldMatrix, cameraPos);
        }
    }

    @SubscribeEvent
    public void renderLevelLast(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91073_ == null || mc.f_91074_ == null) {
            return;
        }
        Camera camera = mc.m_91290_().f_114358_;
        if (camera == null) {
            return;
        }
        PoseStack poseStack = event.getPoseStack();
        worldMatrix = new Matrix4f((Matrix4fc)event.getProjectionMatrix());
        worldMatrix.mul((Matrix4fc)poseStack.m_85850_().m_252922_());
        cameraPos = camera.m_90583_();
    }
}

