/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sekwah.narutomod.capabilities.NinjaCapabilityHandler;
import com.sekwah.narutomod.client.gui.PlayerGUI;
import com.sekwah.narutomod.util.ColorUtil;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class SubstitutionGUI
extends GuiComponent
implements PlayerGUI {
    public static final ResourceLocation LOG_TEXTURE = new ResourceLocation("narutomod", "textures/gui/jutsu/jutsu_substiutution.png");
    private final Minecraft minecraft;
    private final int intTextColor;
    private final int intTextOutline;
    private float substitutions;

    public SubstitutionGUI(Minecraft mc) {
        this.minecraft = mc;
        Color textColor = new Color(255, 255, 255);
        Color textOutline = new Color(0, 0, 0);
        this.intTextColor = ColorUtil.toMCColor(textColor).m_131265_();
        this.intTextOutline = ColorUtil.toMCColor(textOutline).m_131265_();
    }

    @Override
    public void render(PoseStack matrixStack, Matrix4f worldMatrix, Vec3 cameraPos) {
        int screenWidth = this.minecraft.m_91268_().m_85445_();
        int screenHeight = this.minecraft.m_91268_().m_85446_();
        int screenMid = screenWidth / 2;
        int xPos = screenMid + 102;
        int yOffset = 23;
        float brightness = 0.4f;
        int textureWidth = 19;
        int textureHeight = 18;
        float height = this.substitutions % 1.0f;
        if (height == 0.0f) {
            height = 1.0f;
        }
        int pixelHeight = Math.round((float)textureHeight * height);
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)LOG_TEXTURE);
        RenderSystem.m_157429_((float)brightness, (float)brightness, (float)brightness, (float)1.0f);
        SubstitutionGUI.m_93133_((PoseStack)matrixStack, (int)xPos, (int)(screenHeight - yOffset), (float)6.0f, (float)7.0f, (int)textureWidth, (int)textureHeight, (int)32, (int)32);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        SubstitutionGUI.m_93133_((PoseStack)matrixStack, (int)xPos, (int)(screenHeight - yOffset + textureHeight - pixelHeight), (float)6.0f, (float)(7 + textureHeight - pixelHeight), (int)textureWidth, (int)pixelHeight, (int)32, (int)32);
        this.centeredTextOutlined(matrixStack, String.valueOf((int)Math.floor(this.substitutions)), xPos + 15, screenHeight - yOffset + 12, this.intTextColor, this.intTextOutline);
    }

    private void centeredTextOutlined(PoseStack matrixStack, String text, int x, int y, int color, int backgroundColor) {
        int width = this.getFont().m_92895_(text) / 2;
        this.getFont().m_92883_(matrixStack, text, (float)x + 1.0f - (float)width, (float)y, backgroundColor);
        this.getFont().m_92883_(matrixStack, text, (float)x - 1.0f - (float)width, (float)y, backgroundColor);
        this.getFont().m_92883_(matrixStack, text, (float)x - (float)width, (float)y + 1.0f, backgroundColor);
        this.getFont().m_92883_(matrixStack, text, (float)x - (float)width, (float)y - 1.0f, backgroundColor);
        this.getFont().m_92883_(matrixStack, text, (float)x - (float)width, (float)y, color);
    }

    @Override
    public void tick(Player player) {
        player.getCapability(NinjaCapabilityHandler.NINJA_DATA).ifPresent(ninjaData -> {
            this.substitutions = ninjaData.getSubstitutionCount();
        });
    }

    private void setColor(Color color) {
        RenderSystem.m_157429_((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
    }

    private Font getFont() {
        return this.minecraft.f_91062_;
    }
}

