/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.sekwah.narutomod.abilities.jutsus.SubstitutionJutsuAbility;
import com.sekwah.narutomod.capabilities.NinjaCapabilityHandler;
import com.sekwah.narutomod.client.gui.PlayerGUI;
import com.sekwah.narutomod.util.ColorUtil;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public class WorldMarkerGUI
extends GuiComponent
implements PlayerGUI {
    public static final ResourceLocation LOG_TEXTURE = new ResourceLocation("narutomod", "textures/gui/jutsu/jutsu_substiutution_marker.png");
    private final Minecraft minecraft;
    private int screenWidth;
    private int screenHeight;
    private final int intTextColor;
    private final int outOfRangeColor;
    private final int intTextOutline;
    private Vec3 substitutionLoc;

    public WorldMarkerGUI(Minecraft mc) {
        this.minecraft = mc;
        Color textColor = new Color(255, 255, 255);
        Color textOutline = new Color(0, 0, 0);
        Color outOfRangeColor = new Color(255, 99, 99);
        this.intTextColor = ColorUtil.toMCColor(textColor).m_131265_();
        this.outOfRangeColor = ColorUtil.toMCColor(outOfRangeColor).m_131265_();
        this.intTextOutline = ColorUtil.toMCColor(textOutline).m_131265_();
    }

    @Override
    public void render(PoseStack matrixStack, Matrix4f worldMatrix, Vec3 cameraPos) {
        if (this.substitutionLoc == null) {
            return;
        }
        this.screenWidth = this.minecraft.m_91268_().m_85445_();
        this.screenHeight = this.minecraft.m_91268_().m_85446_();
        int halfWidth = this.screenWidth / 2;
        int halfHeight = this.screenHeight / 2;
        float xPos = halfWidth;
        float yOffset = halfHeight;
        int textureWidth = 32;
        int textureHeight = 32;
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_69482_();
        RenderSystem.m_69478_();
        RenderSystem.m_157456_((int)0, (ResourceLocation)LOG_TEXTURE);
        Vector4f vec = new Vector4f((float)(this.substitutionLoc.f_82479_ - cameraPos.f_82479_), (float)(this.substitutionLoc.f_82480_ - cameraPos.f_82480_), (float)(this.substitutionLoc.f_82481_ - cameraPos.f_82481_), 1.0f);
        double distance = cameraPos.m_82554_(this.substitutionLoc);
        vec.mul((Matrix4fc)worldMatrix);
        vec.div(vec.w);
        xPos += vec.x() * (float)halfWidth;
        yOffset -= vec.y() * (float)halfHeight;
        if (vec.z() > 0.0f && vec.z() < 1.0f) {
            float fadeOut = (float)Math.max(Math.min((double)0.6f, distance / 8.0 - 0.5), 0.0);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)fadeOut);
            float scale = (float)(0.5 / Math.pow((distance + 30.0) / 80.0, 2.0));
            matrixStack.m_85836_();
            matrixStack.m_252880_(xPos, yOffset, 0.0f);
            matrixStack.m_85841_(scale, scale, scale);
            WorldMarkerGUI.m_93133_((PoseStack)matrixStack, (int)(-textureWidth / 2), (int)(-textureHeight / 2), (float)0.0f, (float)0.0f, (int)32, (int)32, (int)32, (int)32);
            long roundedDistance = Math.round(distance);
            this.centeredTextOutlined(matrixStack, roundedDistance + " M", 0, 11, roundedDistance <= (long)SubstitutionJutsuAbility.MAX_MARKER_DISTANCE ? this.intTextColor : this.outOfRangeColor, this.intTextOutline);
            matrixStack.m_85849_();
        }
    }

    private void centeredTextOutlined(PoseStack matrixStack, String text, int x, int y, int color, int backgroundColor) {
        int width = this.getFont().m_92895_(text) / 2;
        this.getFont().m_92883_(matrixStack, text, (float)x + 1.0f - (float)width, (float)y, backgroundColor);
        this.getFont().m_92883_(matrixStack, text, (float)x - 1.0f - (float)width, (float)y, backgroundColor);
        this.getFont().m_92883_(matrixStack, text, (float)x - (float)width, (float)y + 1.0f, backgroundColor);
        this.getFont().m_92883_(matrixStack, text, (float)x - (float)width, (float)y - 1.0f, backgroundColor);
        this.getFont().m_92883_(matrixStack, text, (float)x - (float)width, (float)y, color);
    }

    @Override
    public void tick(Player player) {
        player.getCapability(NinjaCapabilityHandler.NINJA_DATA).ifPresent(ninjaData -> {
            this.substitutionLoc = player.f_19853_.m_46472_().m_135782_().equals((Object)ninjaData.getSubstitutionDimension()) ? ninjaData.getSubstitutionLoc() : null;
        });
    }

    private void setColor(Color color) {
        RenderSystem.m_157429_((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f), (float)1.0f);
    }

    private Font getFont() {
        return this.minecraft.f_91062_;
    }
}

