/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.client.renderer.entity.jutsuprojectile;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.sekwah.narutomod.client.model.jutsu.FireballJutsuModel;
import com.sekwah.narutomod.entity.jutsuprojectile.FireballJutsuEntity;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class FireballJutsuRenderer
extends EntityRenderer<FireballJutsuEntity> {
    public static final ResourceLocation FIREBALL_TEX = new ResourceLocation("narutomod", "textures/entity/jutsu/projectiles/fireball.png");
    private static final RenderType RENDER_TYPE = RenderType.m_110473_((ResourceLocation)FIREBALL_TEX);
    private final FireballJutsuModel model;

    public FireballJutsuRenderer(EntityRendererProvider.Context manager) {
        super(manager);
        this.model = new FireballJutsuModel(manager.m_174023_(FireballJutsuModel.LAYER_LOCATION));
    }

    public void render(FireballJutsuEntity fireballJutsuEntity, float p_114486_, float partial, PoseStack poseStack, MultiBufferSource multiBufferSource, int p_114490_) {
        VertexConsumer vertexconsumer = multiBufferSource.m_6299_(RENDER_TYPE);
        poseStack.m_85836_();
        poseStack.m_252880_(0.0f, fireballJutsuEntity.m_20206_() / 2.0f, 0.0f);
        float time = ((float)fireballJutsuEntity.time + partial) * 10.0f;
        float scaleTime = 400.0f;
        if (time < scaleTime) {
            float scale = 0.1f + (0.9f - 0.9f * ((scaleTime - time) / scaleTime));
            poseStack.m_85841_(scale, scale, scale);
        }
        poseStack.m_252781_(Axis.f_252403_.m_252977_(time * 1.5f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(time * 1.5f));
        this.model.m_7695_(poseStack, vertexconsumer, p_114490_, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        super.m_7392_((Entity)fireballJutsuEntity, p_114486_, partial, poseStack, multiBufferSource, p_114490_);
    }

    protected int getBlockLightLevel(FireballJutsuEntity p_114087_, BlockPos p_114088_) {
        return 15;
    }

    public ResourceLocation getTextureLocation(FireballJutsuEntity p_114482_) {
        return FIREBALL_TEX;
    }
}

