/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.config;

import com.sekwah.narutomod.client.gui.BarDesigns;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="narutomod", bus=Mod.EventBusSubscriber.Bus.MOD)
public class NarutoConfig {
    public static final String SERVER = "server";
    public static final String CATEGORY_WEAPONS = "weapons";
    public static final String CATEGORY_PLAYER = "player";
    public static final String CLIENT = "client";
    public static final String CATEGORY_UI = "ui";
    public static final String ENERGY_BARS = "energy_bars";
    public static final ForgeConfigSpec MOD_CONFIG;
    private static final ForgeConfigSpec.DoubleValue CONFIG_MAX_CHAKRA;
    public static float maxChakra;
    private static final ForgeConfigSpec.DoubleValue CONFIG_MAX_STAMINA;
    public static float maxStamina;
    private static final ForgeConfigSpec.DoubleValue CONFIG_CHAKRA_REGEN;
    public static float chakraRegen;
    private static final ForgeConfigSpec.DoubleValue CONFIG_STAMINA_REGEN;
    public static float staminaRegen;
    private static final ForgeConfigSpec.IntValue CONFIG_MAX_SUBSTITUTIONS;
    public static int maxSubstitutions;
    private static final ForgeConfigSpec.IntValue CONFIG_SUBSTITUTION_REGEN_TIME;
    public static float substitutionRegenRate;
    private static final ForgeConfigSpec.BooleanValue CONFIG_KUNAI_BLOCK_DAMAGE;
    public static boolean kunaiBlockDamage;
    private static final ForgeConfigSpec.DoubleValue CONFIG_KUNAI_EXPLOSION_RADIUS;
    public static float kunaiExplosionRadius;
    private static final ForgeConfigSpec.DoubleValue CONFIG_PAPERBOMB_EXPLOSION_RADIUS;
    public static float paperbombExplosionRadius;
    private static final ForgeConfigSpec.BooleanValue CONFIG_PAPERBOMB_BLOCK_DAMAGE;
    public static boolean paperbombBlockDamage;
    private static final ForgeConfigSpec.IntValue CONFIG_JUTSU_KEYBIND_HOLD_THRESHOLD;
    public static int jutsuKeybindHoldThreshold;
    private static final ForgeConfigSpec.IntValue CONFIG_JUTSU_CAST_DELAY;
    public static int jutsuCastDelay;
    private static final ForgeConfigSpec.IntValue CONFIG_CHAKRA_BAR_DESIGN;
    public static int chakraBarDesign;

    public static void loadVariables() {
        maxChakra = ((Double)CONFIG_MAX_CHAKRA.get()).floatValue();
        maxStamina = ((Double)CONFIG_MAX_STAMINA.get()).floatValue();
        staminaRegen = ((Double)CONFIG_STAMINA_REGEN.get()).floatValue();
        chakraRegen = ((Double)CONFIG_CHAKRA_REGEN.get()).floatValue();
        maxSubstitutions = (Integer)CONFIG_MAX_SUBSTITUTIONS.get();
        substitutionRegenRate = 1.0f / ((float)((Integer)CONFIG_SUBSTITUTION_REGEN_TIME.get()).intValue() * 20.0f);
        kunaiBlockDamage = (Boolean)CONFIG_KUNAI_BLOCK_DAMAGE.get();
        kunaiBlockDamage = (Boolean)CONFIG_KUNAI_BLOCK_DAMAGE.get();
        kunaiExplosionRadius = ((Double)CONFIG_KUNAI_EXPLOSION_RADIUS.get()).floatValue();
        paperbombExplosionRadius = ((Double)CONFIG_PAPERBOMB_EXPLOSION_RADIUS.get()).floatValue();
        paperbombBlockDamage = (Boolean)CONFIG_PAPERBOMB_BLOCK_DAMAGE.get();
        jutsuKeybindHoldThreshold = (Integer)CONFIG_JUTSU_KEYBIND_HOLD_THRESHOLD.get();
        chakraBarDesign = (Integer)CONFIG_CHAKRA_BAR_DESIGN.get();
        jutsuCastDelay = (Integer)CONFIG_JUTSU_CAST_DELAY.get();
    }

    @SubscribeEvent
    public static void onLoad(ModConfigEvent.Loading configEvent) {
        NarutoConfig.loadVariables();
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading configEvent) {
        NarutoConfig.loadVariables();
    }

    static {
        ForgeConfigSpec.Builder configBuilder = new ForgeConfigSpec.Builder();
        configBuilder.comment("Server based settings").push(SERVER);
        configBuilder.comment("Player settings").push(CATEGORY_PLAYER);
        configBuilder.comment("Stuff such as regen rates and maximum (will likely change with updates, e.g. stats system)").push(ENERGY_BARS);
        CONFIG_MAX_CHAKRA = configBuilder.comment("Max Chakra").defineInRange("maxChakra", 100.0, 0.0, Double.MAX_VALUE);
        CONFIG_CHAKRA_REGEN = configBuilder.comment("Chakra Regen").defineInRange("chakraRegen", 0.05, 0.0, Double.MAX_VALUE);
        CONFIG_MAX_STAMINA = configBuilder.comment("Max Stamina").defineInRange("maxStamina", 100.0, 0.0, Double.MAX_VALUE);
        CONFIG_STAMINA_REGEN = configBuilder.comment("Stamina Regen").defineInRange("staminaRegen", 0.4, 0.0, Double.MAX_VALUE);
        CONFIG_MAX_SUBSTITUTIONS = configBuilder.comment("Max Substitutions").defineInRange("maxSubstitutions", 3, 0, Integer.MAX_VALUE);
        CONFIG_SUBSTITUTION_REGEN_TIME = configBuilder.comment("Substitution Regen Time (Seconds)").defineInRange("substitutionRegenTime", 60, 0, Integer.MAX_VALUE);
        configBuilder.pop();
        configBuilder.pop();
        configBuilder.comment("Variables for weapons").push(CATEGORY_WEAPONS);
        CONFIG_KUNAI_BLOCK_DAMAGE = configBuilder.comment("Explosive Kunai block damage").define("kunaiExplosionBreakBlocks", true);
        CONFIG_KUNAI_EXPLOSION_RADIUS = configBuilder.comment("Explosive Kunai explosion radius").defineInRange("kunaiExplosionRadius", 3.0, 1.0, 100.0);
        CONFIG_PAPERBOMB_EXPLOSION_RADIUS = configBuilder.comment("Paper Bomb explosion radius").defineInRange("paperBombExplosionRadius", 4.0, 1.0, 100.0);
        CONFIG_PAPERBOMB_BLOCK_DAMAGE = configBuilder.comment("Paper Bomb block damage").define("paperBombExplosionBreakBlocks", true);
        CONFIG_JUTSU_KEYBIND_HOLD_THRESHOLD = configBuilder.comment("Key hold threshold in ticks (20 per second)").defineInRange("jutsuKeyHoldThreshold", 15, 0, Integer.MAX_VALUE);
        CONFIG_JUTSU_CAST_DELAY = configBuilder.comment("Jutsu activation delay (20 per second)").defineInRange("jutsuActivateDelay", 15, 0, Integer.MAX_VALUE);
        configBuilder.pop();
        configBuilder.pop();
        configBuilder.comment("Client based settings").push(CLIENT);
        configBuilder.comment("Variables for UI").push(CATEGORY_UI);
        CONFIG_CHAKRA_BAR_DESIGN = configBuilder.comment("Design for the chara bar").defineInRange("chakraBarDesign", 0, 0, BarDesigns.BarInfo.values().length - 1);
        configBuilder.pop();
        configBuilder.pop();
        MOD_CONFIG = configBuilder.build();
    }
}

