/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.entity.item;

import com.sekwah.narutomod.block.NarutoBlockStates;
import com.sekwah.narutomod.block.NarutoBlocks;
import com.sekwah.narutomod.config.NarutoConfig;
import com.sekwah.narutomod.entity.NarutoDataSerialisers;
import com.sekwah.narutomod.entity.NarutoEntities;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.network.NetworkHooks;

public class PaperBombEntity
extends Entity {
    private static final EntityDataAccessor<Integer> DATA_FUSE_ID = SynchedEntityData.m_135353_(PaperBombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    public LivingEntity owner;
    private static final EntityDataAccessor<Direction> ROTATION = SynchedEntityData.m_135353_(PaperBombEntity.class, NarutoDataSerialisers.BLOCK_DIRECTION);
    private static final EntityDataAccessor<AttachFace> VERT_ROT = SynchedEntityData.m_135353_(PaperBombEntity.class, NarutoDataSerialisers.ATTACH_FACE);
    protected static final EntityDataAccessor<BlockPos> ORIGIN = SynchedEntityData.m_135353_(PaperBombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    private int life = 80;
    private BlockPos anchorLoc;
    public BlockState renderBlockState = ((Block)NarutoBlocks.PAPER_BOMB.get()).m_49966_();

    public PaperBombEntity(EntityType<? extends PaperBombEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public PaperBombEntity(Level worldIn, double x, double y, double z, LivingEntity igniter, Direction direction, AttachFace face, BlockPos anchorTo) {
        this(worldIn, x, y, z, igniter);
        this.anchorLoc = anchorTo;
        this.setRotation(direction);
        this.setVertRotation(face);
        this.setAnchored(!this.isAnchoredBlockAir());
    }

    public PaperBombEntity(Level worldIn, double x, double y, double z, LivingEntity owner) {
        this((EntityType<? extends PaperBombEntity>)((EntityType)NarutoEntities.PAPER_BOMB.get()), worldIn);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.owner = owner;
        this.setOrigin(this.getOrigin());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_FUSE_ID, (Object)80);
        this.f_19804_.m_135372_(ROTATION, (Object)Direction.NORTH);
        this.f_19804_.m_135372_(VERT_ROT, (Object)AttachFace.FLOOR);
        this.f_19804_.m_135372_(ORIGIN, (Object)BlockPos.f_121853_);
    }

    public void setOrigin(BlockPos origin) {
        this.f_19804_.m_135381_(ORIGIN, (Object)origin);
    }

    public BlockPos getOrigin() {
        return (BlockPos)this.f_19804_.m_135370_(ORIGIN);
    }

    public Direction getRotation() {
        return (Direction)this.f_19804_.m_135370_(ROTATION);
    }

    public void setRotation(Direction rotation) {
        this.f_19804_.m_135381_(ROTATION, (Object)rotation);
    }

    public AttachFace getVertRotation() {
        return (AttachFace)this.f_19804_.m_135370_(VERT_ROT);
    }

    public void setVertRotation(AttachFace rotation) {
        this.f_19804_.m_135381_(VERT_ROT, (Object)rotation);
    }

    public void m_8119_() {
        if (!this.m_20068_()) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
        }
        this.m_6478_(MoverType.SELF, this.m_20184_());
        this.m_20256_(this.m_20184_().m_82490_(0.98));
        if (this.f_19861_) {
            this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
        }
        --this.life;
        if (this.life <= 0) {
            this.m_146870_();
            if (!this.f_19853_.f_46443_) {
                this.explode();
            }
        } else {
            this.m_20073_();
            if (this.f_19853_.f_46443_ && this.f_19796_.m_188501_() < 0.3f) {
                Vec3i dir = ((Direction)this.renderBlockState.m_61143_((Property)BlockStateProperties.f_61374_)).m_122436_();
                float yOffset = 0.0f;
                float dirMulti = 0.25f;
                float randomOffset = (this.f_19796_.m_188501_() - 0.5f) * 0.25f;
                switch (this.getVertRotation()) {
                    case FLOOR: {
                        yOffset = 0.15f;
                        break;
                    }
                    case WALL: {
                        yOffset = 0.58f;
                        dirMulti = -0.18f;
                        break;
                    }
                    case CEILING: {
                        yOffset = 0.5f;
                    }
                }
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_() + (double)((float)dir.m_123341_() * dirMulti) + (double)((float)dir.m_123343_() * randomOffset), this.m_20186_() + (double)yOffset, this.m_20189_() + (double)((float)dir.m_123343_() * dirMulti) + (double)((float)dir.m_123341_() * randomOffset), 0.0, 0.0, 0.0);
            }
        }
        if (!this.f_19853_.m_5776_()) {
            if (this.anchorLoc != null && this.isAnchoredBlockAir()) {
                this.setAnchored(false);
            }
            if (this.anchorLoc == null && this.m_20068_() || this.f_19854_ != this.m_20185_() || this.f_19855_ != this.m_20186_() || this.f_19856_ != this.m_20189_()) {
                this.setAnchored(false);
            }
        }
    }

    public boolean isAnchoredBlockAir() {
        BlockState state = this.f_19853_.m_8055_(this.anchorLoc);
        return state.m_60795_();
    }

    public void setAnchored(boolean anchored) {
        if (!anchored) {
            this.anchorLoc = null;
            this.setVertRotation(AttachFace.FLOOR);
        }
        this.m_20242_(anchored);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (DATA_FUSE_ID.equals(key)) {
            this.life = this.getFuse();
        } else if ((ROTATION.equals(key) || VERT_ROT.equals(key)) && this.f_19853_.f_46443_) {
            this.renderBlockState = (BlockState)((BlockState)((BlockState)((Block)NarutoBlocks.PAPER_BOMB.get()).m_49966_().m_61124_((Property)HorizontalDirectionalBlock.f_54117_, (Comparable)this.getRotation())).m_61124_((Property)NarutoBlockStates.HIDDEN, (Comparable)Boolean.FALSE)).m_61124_((Property)FaceAttachedHorizontalDirectionalBlock.f_53179_, (Comparable)this.getVertRotation());
        }
    }

    public void setFuse(int p_184534_1_) {
        this.f_19804_.m_135381_(DATA_FUSE_ID, (Object)p_184534_1_);
        this.life = p_184534_1_;
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE_ID);
    }

    protected void m_7380_(CompoundTag tag) {
        tag.m_128376_("Fuse", (short)this.getLife());
    }

    public int getLife() {
        return this.life;
    }

    protected void m_7378_(CompoundTag tag) {
        this.setFuse(tag.m_128448_("Fuse"));
    }

    protected void explode() {
        this.f_19853_.m_254849_((Entity)this, this.m_20185_(), this.m_20227_(0.0625), this.m_20189_(), NarutoConfig.paperbombExplosionRadius, NarutoConfig.paperbombBlockDamage ? Level.ExplosionInteraction.BLOCK : Level.ExplosionInteraction.NONE);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

