/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.entity.jutsuprojectile;

import com.sekwah.narutomod.damagesource.NarutoDamageSource;
import com.sekwah.narutomod.entity.NarutoEntities;
import com.sekwah.narutomod.sounds.NarutoSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.event.ForgeEventFactory;

public class FireballJutsuEntity
extends AbstractHurtingProjectile {
    public int time;
    public int lifeSpan = 70;
    public float explosionPower = 2.0f;
    public static final float INITIAL_SCALE = 0.1f;
    public static final float GROW_SCALE = 0.9f;
    public static final float GROW_TIME = 40.0f;
    public static final float ENTITY_SIZE = 1.5f;

    public FireballJutsuEntity(EntityType<FireballJutsuEntity> entityConstructor, Level level) {
        super(entityConstructor, level);
        this.time = 0;
    }

    public FireballJutsuEntity(EntityType<? extends AbstractHurtingProjectile> p_36817_, double p_36818_, double p_36819_, double p_36820_, double p_36821_, double p_36822_, double p_36823_, Level p_36824_) {
        super(p_36817_, p_36824_);
        this.m_7678_(p_36818_, p_36819_, p_36820_, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d0 = Math.sqrt(p_36821_ * p_36821_ + p_36822_ * p_36822_ + p_36823_ * p_36823_);
        if (d0 != 0.0) {
            this.f_36813_ = p_36821_ / d0 * 0.2;
            this.f_36814_ = p_36822_ / d0 * 0.2;
            this.f_36815_ = p_36823_ / d0 * 0.2;
        }
    }

    public FireballJutsuEntity(LivingEntity player, double xVel, double yVel, double zVel) {
        this((EntityType<? extends AbstractHurtingProjectile>)((EntityType)NarutoEntities.FIREBALL_JUTSU.get()), player.m_20185_(), player.m_20188_() - (double)0.2f, player.m_20189_(), xVel, yVel, zVel, player.m_9236_());
        this.m_5602_((Entity)player);
        this.m_19915_(player.m_146908_(), player.m_146909_());
    }

    public EntityDimensions m_6972_(Pose p_19721_) {
        return EntityDimensions.m_20395_((float)1.5f, (float)1.5f).m_20388_(Math.min(0.1f + (0.9f - 0.9f * ((40.0f - (float)this.time) / 40.0f)), 1.0f));
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.time;
        this.m_6210_();
        if (this.m_20070_()) {
            --this.lifeSpan;
            if (this.lifeSpan % 5 == 0) {
                this.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
            }
        }
        if (this.m_20069_() || this.lifeSpan-- <= 0) {
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123796_, this.m_20185_(), this.m_20186_() + (double)this.m_20206_() + 1.0, this.m_20189_(), 100, 0.5, 0.2, 0.5, 0.0);
            }
            this.m_5496_(SoundEvents.f_11937_, 1.0f, 1.0f);
            this.m_146870_();
        }
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 200, (double)this.m_20205_(), (double)this.m_20205_(), (double)this.m_20206_(), 1.0);
        }
        if (!this.f_19853_.f_46443_) {
            int flameRadius = 8;
            this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82377_((double)flameRadius, (double)flameRadius, (double)flameRadius)).forEach(entity -> {
                double distance = this.m_20182_().m_82557_(entity.m_20182_());
                if (entity == this.m_37282_()) {
                    distance += 16.0;
                }
                float fireSecs = (float)(8.0 - distance / 6.0) * 20.0f;
                float fireDamage = (float)(12.0 - distance / 4.0);
                if ((float)entity.m_20094_() < fireSecs) {
                    entity.m_7311_(Math.round(fireSecs));
                }
                if (fireDamage > 0.0f) {
                    Entity entity1 = this.m_37282_();
                    if (entity1 instanceof LivingEntity) {
                        entity.m_6469_(NarutoDamageSource.fireball((Entity)this, entity1), fireDamage);
                    }
                    if (entity1 instanceof LivingEntity) {
                        this.m_19970_((LivingEntity)entity1, (Entity)entity);
                    }
                }
            });
            boolean flag = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this.m_37282_());
            if (flag) {
                int fireSpread = 2;
                for (int x = (int)this.m_20185_() - fireSpread; x < (int)this.m_20185_() + fireSpread - 1; ++x) {
                    for (int y = (int)this.m_20186_() - fireSpread + 1; y < (int)this.m_20186_() + fireSpread; ++y) {
                        for (int z = (int)this.m_20189_() - fireSpread + 1; z < (int)this.m_20189_() + fireSpread; ++z) {
                            BlockPos blockPos = new BlockPos(x, y, z);
                            if (this.f_19796_.m_188503_(2) != 0 || !this.f_19853_.m_8055_(blockPos).m_60795_()) continue;
                            this.f_19853_.m_46597_(blockPos, BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)blockPos));
                        }
                    }
                }
            }
            this.m_5496_((SoundEvent)NarutoSounds.FIREBALL_EXPLODE.get(), 4.0f, 1.0f);
            this.m_146870_();
        }
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public boolean m_6469_(DamageSource p_36910_, float p_36911_) {
        return false;
    }

    protected ParticleOptions m_5967_() {
        return this.m_20070_() ? ParticleTypes.f_123796_ : ParticleTypes.f_123755_;
    }

    public boolean m_6087_() {
        return false;
    }

    public float m_213856_() {
        return 1.0f;
    }

    protected boolean m_5931_() {
        return false;
    }

    public void m_141965_(ClientboundAddEntityPacket p_150128_) {
        super.m_141965_(p_150128_);
        double d0 = p_150128_.m_131503_();
        double d1 = p_150128_.m_131504_();
        double d2 = p_150128_.m_131505_();
        double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
        if (d3 != 0.0) {
            this.f_36813_ = d0 / d3 * 0.2;
            this.f_36814_ = d1 / d3 * 0.2;
            this.f_36815_ = d2 / d3 * 0.2;
        }
    }
}

