/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.entity.jutsuprojectile;

import com.sekwah.narutomod.damagesource.NarutoDamageSource;
import com.sekwah.narutomod.entity.NarutoEntities;
import com.sekwah.narutomod.entity.projectile.AbstractNonGlowingHurtingProjectile;
import com.sekwah.narutomod.sounds.NarutoSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public class WaterBulletJutsuEntity
extends AbstractNonGlowingHurtingProjectile {
    public int lifeSpan = 30;
    private final double multiplier = 0.52;

    public WaterBulletJutsuEntity(EntityType<WaterBulletJutsuEntity> entityConstructor, Level level) {
        super(entityConstructor, level);
    }

    public WaterBulletJutsuEntity(EntityType<? extends AbstractNonGlowingHurtingProjectile> entityType, double posX, double posY, double posZ, double velX, double velY, double velZ, Level p_36824_) {
        super(entityType, p_36824_);
        this.m_7678_(posX, posY, posZ, this.m_146908_(), this.m_146909_());
        this.m_20090_();
        double d0 = Math.sqrt(velX * velX + velY * velY + velZ * velZ);
        if (d0 != 0.0) {
            this.xPower = velX / d0 * 0.52;
            this.yPower = velY / d0 * 0.52;
            this.zPower = velZ / d0 * 0.52;
        }
    }

    public WaterBulletJutsuEntity(LivingEntity player, double xVel, double yVel, double zVel) {
        this((EntityType<? extends AbstractNonGlowingHurtingProjectile>)((EntityType)NarutoEntities.WATER_BULLET_JUTSU.get()), player.m_20185_(), player.m_20188_() - (double)0.15f, player.m_20189_(), xVel, yVel, zVel, player.m_9236_());
        this.m_5602_((Entity)player);
        this.m_19915_(player.m_146908_(), player.m_146909_());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.lifeSpan-- <= 0) {
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 100, 3.0, 3.0, 3.0, 1.0);
            }
            this.m_5496_((SoundEvent)NarutoSounds.WATER_BULLET_SPLASH.get(), 3.0f, 1.0f);
            this.m_146870_();
        }
        if (this.m_20069_()) {
            Vec3 vec3 = this.m_20184_();
            this.m_20256_(vec3.m_82520_(this.xPower, this.yPower, this.zPower).m_82490_(1.0));
        }
    }

    protected void m_5790_(EntityHitResult p_37216_) {
        super.m_5790_(p_37216_);
        if (!this.f_19853_.f_46443_) {
            Entity entity = p_37216_.m_82443_();
            Entity entity1 = this.m_37282_();
            entity.m_6469_(NarutoDamageSource.causeWaterBullet((Entity)this, entity1), 7.0f);
            if (entity1 instanceof LivingEntity) {
                this.m_19970_((LivingEntity)entity1, entity);
            }
        }
    }

    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 100, (double)this.m_20205_(), (double)this.m_20205_(), (double)this.m_20206_(), 1.0);
            serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 100, 3.0, 3.0, 3.0, 1.0);
        }
        if (!this.f_19853_.f_46443_) {
            int splashRadius = 8;
            this.f_19853_.m_45933_((Entity)this, this.m_20191_().m_82377_((double)splashRadius, (double)splashRadius, (double)splashRadius)).forEach(entity -> {
                if (entity instanceof LivingEntity) {
                    float damage;
                    double distance = this.m_20182_().m_82557_(entity.m_20182_());
                    if (entity != this.m_37282_() && (damage = (float)(5.0 - distance / 4.0)) > 0.0f) {
                        Entity entity1 = this.m_37282_();
                        entity.m_6469_(NarutoDamageSource.causeWaterBullet((Entity)this, entity1), damage);
                        if (entity1 instanceof LivingEntity) {
                            this.m_19970_((LivingEntity)entity1, (Entity)entity);
                        }
                    }
                    entity.m_20095_();
                }
            });
            boolean flag = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this.m_37282_());
            if (flag) {
                int extinguish = 4;
                for (int x = (int)this.m_20185_() - extinguish; x < (int)this.m_20185_() + extinguish - 1; ++x) {
                    for (int y = (int)this.m_20186_() - extinguish + 1; y < (int)this.m_20186_() + extinguish; ++y) {
                        for (int z = (int)this.m_20189_() - extinguish + 1; z < (int)this.m_20189_() + extinguish; ++z) {
                            BlockPos blockPos = new BlockPos(x, y, z);
                            if (this.f_19853_.m_8055_(blockPos).m_60734_() != Blocks.f_50083_) continue;
                            this.f_19853_.m_46597_(blockPos, Blocks.f_50016_.m_49966_());
                        }
                    }
                }
            }
            this.m_5496_((SoundEvent)NarutoSounds.WATER_BULLET_SPLASH.get(), 3.0f, 1.0f);
            this.m_146870_();
        }
    }

    @Override
    public boolean m_6469_(DamageSource p_36910_, float p_36911_) {
        return false;
    }

    @Override
    protected ParticleOptions getTrailParticle() {
        return ParticleTypes.f_123769_;
    }

    @Override
    public boolean m_6087_() {
        return false;
    }

    @Override
    protected boolean shouldBurn() {
        return false;
    }

    @Override
    public void m_141965_(ClientboundAddEntityPacket p_150128_) {
        double d2;
        double d1;
        double d0;
        double d3;
        super.m_141965_(p_150128_);
        if (this.m_37282_() != null) {
            this.m_146922_(this.m_37282_().m_146908_() - 180.0f);
            this.f_19859_ = this.m_146908_();
        }
        if ((d3 = Math.sqrt((d0 = p_150128_.m_131503_()) * d0 + (d1 = p_150128_.m_131504_()) * d1 + (d2 = p_150128_.m_131505_()) * d2)) != 0.0) {
            this.xPower = d0 / d3 * 0.52;
            this.yPower = d1 / d3 * 0.52;
            this.zPower = d2 / d3 * 0.52;
        }
    }
}

