/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.item.armor;

import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.LazyLoadedValue;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public enum NarutoArmorMaterial implements ArmorMaterial
{
    ANBU_MAT("anbu", 35, new int[]{2, 5, 7, 2}, 8, null, 2.1f, 0.0f, () -> null),
    FLAK_MAT("flak", 35, new int[]{2, 5, 6, 2}, 8, null, 2.1f, 0.0f, () -> null),
    FLAK_STRONGER_MAT("flak_strong", 35, new int[]{2, 7, 7, 2}, 8, null, 2.1f, 0.0f, () -> null),
    CHARACTER_CLOTHES("character_clothes", 35, new int[]{2, 5, 7, 2}, 8, null, 2.1f, 0.0f, () -> null),
    FULL_CHARACTER_CLOTHES("full_character_clothes", 35, new int[]{2, 5, 10, 2}, 6, null, 2.1f, 0.0f, () -> null),
    HEADBAND("headband", 35, new int[]{2, 5, 5, 2}, 6, null, 2.1f, 0.0f, () -> null);

    private static final int[] HEALTH_PER_SLOT;
    private final String name;
    private final int durabilityMultiplier;
    private final int[] slotProtections;
    private final int enchantmentValue;
    private final SoundEvent sound;
    private final float toughness;
    private final float knockbackResistance;
    private final LazyLoadedValue<Ingredient> repairIngredient;

    private NarutoArmorMaterial(String name, int durabilityMultiplier, int[] slotProtections, int enchantmentValue, SoundEvent soundEvent, float toughness, float knockbackResistance, Supplier<Ingredient> repairIngredient) {
        this.name = name;
        this.durabilityMultiplier = durabilityMultiplier;
        this.slotProtections = slotProtections;
        this.enchantmentValue = enchantmentValue;
        this.sound = soundEvent;
        this.toughness = toughness;
        this.knockbackResistance = knockbackResistance;
        this.repairIngredient = new LazyLoadedValue(repairIngredient);
    }

    public int m_7366_(EquipmentSlot p_200896_1_) {
        return HEALTH_PER_SLOT[p_200896_1_.m_20749_()] * this.durabilityMultiplier;
    }

    public int m_7365_(EquipmentSlot p_200902_1_) {
        return this.slotProtections[p_200902_1_.m_20749_()];
    }

    public int m_6646_() {
        return this.enchantmentValue;
    }

    public SoundEvent m_7344_() {
        return this.sound;
    }

    public Ingredient m_6230_() {
        return (Ingredient)this.repairIngredient.m_13971_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public String m_6082_() {
        return this.name;
    }

    public float m_6651_() {
        return this.toughness;
    }

    public float m_6649_() {
        return this.knockbackResistance;
    }

    static {
        HEALTH_PER_SLOT = new int[]{13, 15, 16, 11};
    }
}

