/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.network;

import com.sekwah.narutomod.network.c2s.ServerAbilityActivatePacket;
import com.sekwah.narutomod.network.c2s.ServerAbilityChannelPacket;
import com.sekwah.narutomod.network.c2s.ServerJutsuCastingPacket;
import com.sekwah.narutomod.network.c2s.ServerToggleNinjaPacket;
import com.sekwah.narutomod.network.s2c.ClientTestPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PacketHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"NarutoMod:PacketHandler");
    public static final String PROTOCOL_VERSION = ModList.get().getModFileById("narutomod").versionString();
    public static final SimpleChannel NARUTO_CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("narutomod", "naruto_data")).networkProtocolVersion(() -> PROTOCOL_VERSION).clientAcceptedVersions(version -> version.equals(PROTOCOL_VERSION)).serverAcceptedVersions(version -> version.equals(PROTOCOL_VERSION)).simpleChannel();
    private static int packetId = 0;

    public static void init() {
        NARUTO_CHANNEL.registerMessage(PacketHandler.getPacketID(), ClientTestPacket.class, ClientTestPacket::encode, ClientTestPacket::decode, ClientTestPacket.Handler::handle);
        NARUTO_CHANNEL.registerMessage(PacketHandler.getPacketID(), ServerJutsuCastingPacket.class, ServerJutsuCastingPacket::encode, ServerJutsuCastingPacket::decode, ServerJutsuCastingPacket.Handler::handle);
        NARUTO_CHANNEL.registerMessage(PacketHandler.getPacketID(), ServerAbilityActivatePacket.class, ServerAbilityActivatePacket::encode, ServerAbilityActivatePacket::decode, ServerAbilityActivatePacket.Handler::handle);
        NARUTO_CHANNEL.registerMessage(PacketHandler.getPacketID(), ServerAbilityChannelPacket.class, ServerAbilityChannelPacket::encode, ServerAbilityChannelPacket::decode, ServerAbilityChannelPacket.Handler::handle);
        NARUTO_CHANNEL.registerMessage(PacketHandler.getPacketID(), ServerToggleNinjaPacket.class, ServerToggleNinjaPacket::encode, ServerToggleNinjaPacket::decode, ServerToggleNinjaPacket.Handler::handle);
    }

    private static int getPacketID() {
        return packetId++;
    }

    public static void sendToServer(Object obj) {
        NARUTO_CHANNEL.sendToServer(obj);
    }

    public static void sendToPlayer(Object obj, ServerPlayer player) {
        NARUTO_CHANNEL.sendTo(obj, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void sentToTrackingAndSelf(Object obj, ServerPlayer player) {
        NARUTO_CHANNEL.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> player), obj);
    }

    public static void sentToTracking(Object obj, Entity entity) {
        NARUTO_CHANNEL.send(PacketDistributor.TRACKING_ENTITY.with(() -> entity), obj);
    }
}

