/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.network.c2s;

import com.sekwah.narutomod.abilities.Ability;
import com.sekwah.narutomod.capabilities.INinjaData;
import com.sekwah.narutomod.capabilities.NinjaCapabilityHandler;
import com.sekwah.narutomod.capabilities.toggleabilitydata.ToggleAbilityData;
import com.sekwah.narutomod.gameevents.NarutoGameEvents;
import com.sekwah.narutomod.registries.NarutoRegistries;
import java.util.HashSet;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.network.NetworkEvent;

public class ServerAbilityActivatePacket {
    private final int abilityId;

    public ServerAbilityActivatePacket(ResourceLocation ability) {
        this.abilityId = NarutoRegistries.ABILITIES.getID(ability);
    }

    public ServerAbilityActivatePacket(int abilityId) {
        this.abilityId = abilityId;
    }

    public static void encode(ServerAbilityActivatePacket msg, FriendlyByteBuf outBuffer) {
        outBuffer.writeInt(msg.abilityId);
    }

    public static ServerAbilityActivatePacket decode(FriendlyByteBuf inBuffer) {
        int abilityId = inBuffer.readInt();
        return new ServerAbilityActivatePacket(abilityId);
    }

    public static class Handler {
        public static void handle(ServerAbilityActivatePacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null || player.f_8941_.m_9290_() == GameType.SPECTATOR) {
                    return;
                }
                player.getCapability(NinjaCapabilityHandler.NINJA_DATA).ifPresent(ninjaData -> {
                    if (!ninjaData.isNinjaModeEnabled()) {
                        player.m_5661_((Component)Component.m_237115_((String)"jutsu.not_a_ninja").m_130940_(ChatFormatting.RED), true);
                        return;
                    }
                    Ability ability = (Ability)NarutoRegistries.ABILITIES.getValue(msg.abilityId);
                    if (ability.activationType() == Ability.ActivationType.INSTANT) {
                        boolean canTriggerJutsu = true;
                        if (ability instanceof Ability.Cooldown) {
                            boolean bl = canTriggerJutsu = !((Ability.Cooldown)((Object)ability)).checkCooldown((Player)player, (INinjaData)ninjaData, ability.getTranslationKey((INinjaData)ninjaData));
                        }
                        if (canTriggerJutsu && ability.handleCost((Player)player, (INinjaData)ninjaData)) {
                            if (ability.logInChat()) {
                                player.m_5661_((Component)Component.m_237110_((String)"jutsu.cast", (Object[])new Object[]{Component.m_237115_((String)ability.getTranslationKey((INinjaData)ninjaData)).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GREEN), true);
                            }
                            if (ability.castingSound() != null) {
                                player.m_9236_().m_6269_(null, (Entity)player, ability.castingSound(), SoundSource.PLAYERS, 0.5f, 1.0f);
                                player.m_9236_().m_220400_((Entity)player, (GameEvent)NarutoGameEvents.JUTSU_CASTING.get(), player.m_20182_().m_82520_(0.0, (double)player.m_20192_() * 0.7, 0.0));
                            }
                            ability.performServer((Player)player, (INinjaData)ninjaData);
                            if (ability instanceof Ability.Cooldown) {
                                ((Ability.Cooldown)((Object)ability)).registerCooldown((INinjaData)ninjaData, ability.getTranslationKey((INinjaData)ninjaData));
                            }
                        } else if (ability.castingFailSound() != null) {
                            player.m_6330_(ability.castingFailSound(), SoundSource.PLAYERS, 0.5f, 1.0f);
                        }
                    } else if (ability.activationType() == Ability.ActivationType.TOGGLE) {
                        ToggleAbilityData abilityTracker = ninjaData.getToggleAbilityData();
                        HashSet<ResourceLocation> abilities = abilityTracker.getAbilitiesHashSet();
                        NarutoRegistries.ABILITIES.getResourceKey((Object)ability).ifPresent(abilityResourceKey -> {
                            ResourceLocation location = abilityResourceKey.m_135782_();
                            if (abilities.contains(location)) {
                                abilityTracker.removeAbilityEnded((Player)player, (INinjaData)ninjaData, ability);
                            } else {
                                abilityTracker.addAbilityStarted((Player)player, (INinjaData)ninjaData, ability);
                            }
                        });
                    }
                });
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

