/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.network.c2s;

import com.mojang.logging.LogUtils;
import com.sekwah.narutomod.abilities.Ability;
import com.sekwah.narutomod.capabilities.INinjaData;
import com.sekwah.narutomod.capabilities.NinjaCapabilityHandler;
import com.sekwah.narutomod.gameevents.NarutoGameEvents;
import com.sekwah.narutomod.registries.NarutoRegistries;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.network.NetworkEvent;
import org.slf4j.Logger;

public class ServerAbilityChannelPacket {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final ResourceLocation abilityResource;
    private final ChannelStatus status;

    public ServerAbilityChannelPacket(ResourceLocation abilityResource, ChannelStatus status) {
        this.abilityResource = abilityResource;
        this.status = status;
    }

    public static void encode(ServerAbilityChannelPacket msg, FriendlyByteBuf outBuffer) {
        outBuffer.m_130085_(msg.abilityResource);
        outBuffer.writeInt(msg.status.ordinal());
    }

    public static ServerAbilityChannelPacket decode(FriendlyByteBuf inBuffer) {
        ResourceLocation abilityResource = inBuffer.m_130281_();
        int status = inBuffer.readInt();
        return new ServerAbilityChannelPacket(abilityResource, ChannelStatus.values()[status]);
    }

    public static enum ChannelStatus {
        START,
        STOP,
        MIN_ACTIVATE;

    }

    public static class Handler {
        public static void handle(ServerAbilityChannelPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player == null || player.f_8941_.m_9290_() == GameType.SPECTATOR) {
                    return;
                }
                player.getCapability(NinjaCapabilityHandler.NINJA_DATA).ifPresent(ninjaData -> {
                    if (!ninjaData.isNinjaModeEnabled()) {
                        player.m_5661_((Component)Component.m_237115_((String)"jutsu.not_a_ninja").m_130940_(ChatFormatting.RED), true);
                        return;
                    }
                    Ability ability = (Ability)NarutoRegistries.ABILITIES.getValue(msg.abilityResource);
                    if (ability == null) {
                        LOGGER.error("Ability doesnt exist {}", (Object)msg.abilityResource);
                        return;
                    }
                    if (ability.activationType() == Ability.ActivationType.CHANNELED) {
                        if (msg.status == ChannelStatus.START) {
                            ninjaData.setCurrentlyChanneledAbility((Player)player, ability);
                        } else if (msg.status == ChannelStatus.STOP) {
                            NarutoRegistries.ABILITIES.getResourceKey((Object)ability).ifPresent(resourceKey -> {
                                if (ninjaData.getCurrentlyChanneledAbility().equals((Object)resourceKey.m_135782_())) {
                                    ability.performServer((Player)player, (INinjaData)ninjaData, ninjaData.getCurrentlyChanneledTicks());
                                    ninjaData.setCurrentlyChanneledAbility((Player)player, null);
                                }
                            });
                        } else if (msg.status == ChannelStatus.MIN_ACTIVATE) {
                            Ability.Channeled channeled;
                            if (ability instanceof Ability.Channeled && (channeled = (Ability.Channeled)((Object)ability)).canActivateBelowMinCharge()) {
                                if (ability.handleCost((Player)player, (INinjaData)ninjaData, -1)) {
                                    if (ability.castingSound() != null) {
                                        player.m_9236_().m_6269_(null, (Entity)player, ability.castingSound(), SoundSource.PLAYERS, 0.5f, 1.0f);
                                        player.m_9236_().m_220400_((Entity)player, (GameEvent)NarutoGameEvents.JUTSU_CASTING.get(), player.m_20182_().m_82520_(0.0, (double)player.m_20192_() * 0.7, 0.0));
                                    }
                                    player.m_5661_((Component)Component.m_237110_((String)"jutsu.cast", (Object[])new Object[]{Component.m_237115_((String)ability.getTranslationKey((INinjaData)ninjaData)).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.GREEN), true);
                                    ability.performServer((Player)player, (INinjaData)ninjaData, -1);
                                }
                            } else {
                                player.m_5661_((Component)Component.m_237110_((String)"jutsu.channel.needed", (Object[])new Object[]{Component.m_237115_((String)ability.getTranslationKey((INinjaData)ninjaData)).m_130940_(ChatFormatting.YELLOW)}).m_130940_(ChatFormatting.RED), true);
                            }
                        }
                    }
                });
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

