/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.network.c2s;

import com.sekwah.narutomod.capabilities.NinjaCapabilityHandler;
import com.sekwah.narutomod.gameevents.NarutoGameEvents;
import com.sekwah.narutomod.sounds.NarutoSounds;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.network.NetworkEvent;

public class ServerJutsuCastingPacket {
    private final int jutsuKey;

    public ServerJutsuCastingPacket(int jutsuKey) {
        this.jutsuKey = jutsuKey;
    }

    public static void encode(ServerJutsuCastingPacket msg, FriendlyByteBuf outBuffer) {
        outBuffer.writeInt(msg.jutsuKey);
    }

    public static ServerJutsuCastingPacket decode(FriendlyByteBuf inBuffer) {
        int jutsuKey = inBuffer.readInt();
        return new ServerJutsuCastingPacket(jutsuKey);
    }

    public static class Handler {
        public static void handle(ServerJutsuCastingPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    player.getCapability(NinjaCapabilityHandler.NINJA_DATA).ifPresent(ninjaData -> {
                        SoundEvent playSound;
                        if (!ninjaData.isNinjaModeEnabled()) {
                            player.m_5661_((Component)Component.m_237115_((String)"jutsu.not_a_ninja").m_130940_(ChatFormatting.RED), true);
                            return;
                        }
                        if (player.f_8941_.m_9290_() == GameType.SPECTATOR) {
                            return;
                        }
                        switch (msg.jutsuKey) {
                            case 1: {
                                SoundEvent soundEvent = (SoundEvent)NarutoSounds.SEAL_A.get();
                                break;
                            }
                            case 2: {
                                SoundEvent soundEvent = (SoundEvent)NarutoSounds.SEAL_B.get();
                                break;
                            }
                            case 3: {
                                SoundEvent soundEvent = (SoundEvent)NarutoSounds.SEAL_C.get();
                                break;
                            }
                            default: {
                                SoundEvent soundEvent = playSound = null;
                            }
                        }
                        if (playSound != null) {
                            player.m_20193_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), playSound, SoundSource.PLAYERS, 1.0f, 1.0f);
                            player.m_9236_().m_220400_((Entity)player, (GameEvent)NarutoGameEvents.JUTSU_CASTING.get(), player.m_20182_().m_82520_(0.0, (double)player.m_20192_() * 0.7, 0.0));
                        }
                    });
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

