/*
 * Decompiled with CFR 0.152.
 */
package com.sekwah.narutomod.network.c2s;

import com.sekwah.narutomod.capabilities.NinjaCapabilityHandler;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;

public class ServerToggleNinjaPacket {
    private final boolean enableNinja;

    public ServerToggleNinjaPacket(boolean jutsuKey) {
        this.enableNinja = jutsuKey;
    }

    public static void encode(ServerToggleNinjaPacket msg, FriendlyByteBuf outBuffer) {
        outBuffer.writeBoolean(msg.enableNinja);
    }

    public static ServerToggleNinjaPacket decode(FriendlyByteBuf inBuffer) {
        boolean enableNinja = inBuffer.readBoolean();
        return new ServerToggleNinjaPacket(enableNinja);
    }

    public static class Handler {
        public static void handle(ServerToggleNinjaPacket msg, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> {
                ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player != null) {
                    player.getCapability(NinjaCapabilityHandler.NINJA_DATA).ifPresent(ninjaData -> ninjaData.setIsNinja(msg.enableNinja));
                }
            });
            ctx.get().setPacketHandled(true);
        }
    }
}

