/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.configured.client.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mrcrayfish.configured.client.screen.IBackgroundTexture;
import com.mrcrayfish.configured.client.screen.ILabelProvider;
import com.mrcrayfish.configured.client.screen.TooltipScreen;
import com.mrcrayfish.configured.client.screen.widget.IconButton;
import com.mrcrayfish.configured.client.util.ScreenUtil;
import com.mrcrayfish.configured.util.ConfigHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;

public abstract class ListMenuScreen
extends TooltipScreen
implements IBackgroundTexture {
    public static final ResourceLocation CONFIGURED_LOGO = new ResourceLocation("configured", "textures/gui/logo.png");
    protected final Screen parent;
    protected final ResourceLocation background;
    protected final int itemHeight;
    protected EntryList list;
    protected List<Item> entries;
    protected FocusedEditBox activeTextField;
    protected FocusedEditBox searchTextField;

    protected ListMenuScreen(Screen parent, Component title, ResourceLocation background, int itemHeight) {
        super(title);
        this.parent = parent;
        this.background = background;
        this.itemHeight = itemHeight;
    }

    protected abstract void constructEntries(List<Item> var1);

    @Override
    public ResourceLocation getBackgroundTexture() {
        return this.background;
    }

    protected void m_7856_() {
        ArrayList<Item> entries = new ArrayList<Item>();
        this.constructEntries(entries);
        this.entries = ImmutableList.copyOf(entries);
        this.list = new EntryList(this.entries);
        this.list.m_93488_(!ConfigHelper.isPlayingGame());
        this.m_7787_((GuiEventListener)this.list);
        this.searchTextField = new FocusedEditBox(this.f_96547_, this.f_96543_ / 2 - 110, 22, 220, 20, (Component)Component.m_237115_((String)"configured.gui.search"));
        this.searchTextField.setClearable(true);
        this.searchTextField.m_94151_(s -> this.updateSearchResults());
        this.m_7787_((GuiEventListener)this.searchTextField);
        ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, "", this.entries);
    }

    protected void updateSearchResults() {
        String query = this.searchTextField.m_94155_();
        ScreenUtil.updateSearchTextFieldSuggestion(this.searchTextField, query, this.entries);
        this.list.m_5988_(query.isEmpty() ? this.entries : this.getSearchResults(query));
        if (!query.isEmpty()) {
            this.list.m_93410_(0.0);
        }
    }

    protected Collection<Item> getSearchResults(String s) {
        return this.entries.stream().filter(item -> !(item instanceof IIgnoreSearch) && item.getLabel().toLowerCase(Locale.ENGLISH).contains(s.toLowerCase(Locale.ENGLISH))).collect(Collectors.toList());
    }

    protected void updateTooltip(int mouseX, int mouseY) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, mouseX, mouseY)) {
            this.setActiveTooltip((Component)Component.m_237115_((String)"configured.gui.info"));
        }
    }

    public void m_86600_() {
        this.searchTextField.m_94120_();
    }

    public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.resetTooltip();
        this.m_7333_(poseStack);
        this.list.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        this.searchTextField.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        ListMenuScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)7, (int)0xFFFFFF);
        super.m_86412_(poseStack, mouseX, mouseY, partialTicks);
        this.renderForeground(poseStack, mouseX, mouseY, partialTicks);
        RenderSystem.m_157456_((int)0, (ResourceLocation)CONFIGURED_LOGO);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Screen.m_93143_((PoseStack)poseStack, (int)10, (int)13, (int)this.m_93252_(), (float)0.0f, (float)0.0f, (int)23, (int)23, (int)32, (int)32);
        RenderSystem.m_157456_((int)0, (ResourceLocation)IconButton.ICONS);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Screen.m_93160_((PoseStack)poseStack, (int)(this.f_96543_ / 2 - 128), (int)26, (int)14, (int)14, (float)22.0f, (float)11.0f, (int)10, (int)10, (int)64, (int)64);
        this.updateTooltip(mouseX, mouseY);
        if (this.tooltipText != null) {
            this.drawTooltip(poseStack, mouseX, mouseY);
        } else {
            GuiEventListener widget;
            Iterator iterator = this.m_6702_().iterator();
            while (!(!iterator.hasNext() || (widget = (GuiEventListener)iterator.next()) instanceof Button && ((Button)widget).m_198029_())) {
            }
        }
    }

    protected void renderForeground(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (ScreenUtil.isMouseWithin(10, 13, 23, 23, (int)mouseX, (int)mouseY)) {
            Style style = Style.f_131099_.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://www.curseforge.com/minecraft/mc-mods/configured"));
            this.m_5561_(style);
            return true;
        }
        if (this.activeTextField != null && !this.activeTextField.m_5953_(mouseX, mouseY)) {
            this.activeTextField.m_93692_(false);
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected class EntryList
    extends ContainerObjectSelectionList<Item>
    implements IBackgroundTexture {
        public EntryList(List<Item> entries) {
            super(ListMenuScreen.this.f_96541_, ListMenuScreen.this.f_96543_, ListMenuScreen.this.f_96544_, 50, ListMenuScreen.this.f_96544_ - 36, ListMenuScreen.this.itemHeight);
            entries.forEach(x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
        }

        protected int m_5756_() {
            return this.f_93388_ / 2 + 144;
        }

        public int m_5759_() {
            return 260;
        }

        @Override
        public ResourceLocation getBackgroundTexture() {
            return ListMenuScreen.this.background;
        }

        public void m_5988_(Collection<Item> entries) {
            super.m_5988_(entries);
        }

        public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            super.m_86412_(poseStack, mouseX, mouseY, partialTicks);
            this.renderToolTips(poseStack, mouseX, mouseY);
        }

        private void renderToolTips(PoseStack poseStack, int mouseX, int mouseY) {
            this.m_6702_().forEach(item -> item.m_6702_().forEach(o -> {
                if (o instanceof Button) {
                    // empty if block
                }
            }));
        }
    }

    protected class FocusedEditBox
    extends EditBox {
        private boolean clearable;

        public FocusedEditBox(Font font, int x, int y, int width, int height, Component label) {
            super(font, x, y, width, height, label);
            this.clearable = false;
        }

        public FocusedEditBox setClearable(boolean clearable) {
            this.clearable = clearable;
            return this;
        }

        protected void m_93692_(boolean focused) {
            super.m_93692_(focused);
            if (focused) {
                if (ListMenuScreen.this.activeTextField != null && ListMenuScreen.this.activeTextField != this) {
                    ListMenuScreen.this.activeTextField.m_93692_(false);
                }
                ListMenuScreen.this.activeTextField = this;
            }
        }

        public void m_86412_(PoseStack poseStack, int mouseX, int mouseY, float partialTick) {
            super.m_86412_(poseStack, mouseX, mouseY, partialTick);
            if (this.clearable && !this.m_94155_().isEmpty()) {
                RenderSystem.m_157427_(GameRenderer::m_172820_);
                RenderSystem.m_157456_((int)0, (ResourceLocation)IconButton.ICONS);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)this.f_93625_);
                boolean hovered = ScreenUtil.isMouseWithin(this.m_252754_() + this.f_93618_ - 15, this.m_252907_() + 5, 9, 9, mouseX, mouseY);
                FocusedEditBox.m_93160_((PoseStack)poseStack, (int)(this.m_252754_() + this.f_93618_ - 15), (int)(this.m_252907_() + 5), (int)9, (int)9, (float)(hovered ? 9.0f : 0.0f), (float)55.0f, (int)9, (int)9, (int)64, (int)64);
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.clearable && !this.m_94155_().isEmpty() && button == 0 && ScreenUtil.isMouseWithin(this.m_252754_() + this.f_93618_ - 15, this.m_252907_() + 5, 9, 9, (int)mouseX, (int)mouseY)) {
                this.m_7435_(ListMenuScreen.this.f_96541_.m_91106_());
                this.m_94144_("");
                return true;
            }
            return super.m_6375_(mouseX, mouseY, button);
        }
    }

    protected static interface IIgnoreSearch {
    }

    protected abstract class Item
    extends ContainerObjectSelectionList.Entry<Item>
    implements ILabelProvider,
    Comparable<Item> {
        protected final Component label;
        @Nullable
        protected List<FormattedCharSequence> tooltip;

        public Item(Component label) {
            this.label = label;
        }

        public Item(String label) {
            this.label = Component.m_237113_((String)label);
        }

        @Override
        public String getLabel() {
            return this.label.getString();
        }

        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            if (this.m_5953_(mouseX, mouseY)) {
                ListMenuScreen.this.setActiveTooltip(this.tooltip);
            }
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        public List<? extends NarratableEntry> m_142437_() {
            return ImmutableList.of((Object)new NarratableEntry(){

                public NarratableEntry.NarrationPriority m_142684_() {
                    return NarratableEntry.NarrationPriority.HOVERED;
                }

                public void m_142291_(NarrationElementOutput output) {
                    output.m_169146_(NarratedElementType.TITLE, Item.this.label);
                }
            });
        }

        @Override
        public int compareTo(Item o) {
            return this.label.getString().compareTo(o.label.getString());
        }
    }

    public class MultiTextItem
    extends Item
    implements IIgnoreSearch {
        private final Component bottomText;

        public MultiTextItem(Component topText, Component bottomText) {
            super(topText);
            this.bottomText = bottomText;
        }

        @Override
        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            Style style;
            HoverEvent event;
            Screen.m_93215_((PoseStack)poseStack, (Font)((ListMenuScreen)ListMenuScreen.this).f_96541_.f_91062_, (Component)this.label, (int)(left + width / 2), (int)top, (int)-1);
            Screen.m_93215_((PoseStack)poseStack, (Font)((ListMenuScreen)ListMenuScreen.this).f_96541_.f_91062_, (Component)this.bottomText, (int)(left + width / 2), (int)(top + 12), (int)-1);
            if (this.m_5953_(mouseX, mouseY) && (event = (style = this.bottomText.m_7383_()).m_131186_()) != null && event.m_130820_() == HoverEvent.Action.f_130831_) {
                ListMenuScreen.this.setActiveTooltip((Component)event.m_130823_(HoverEvent.Action.f_130831_), -219136);
            }
        }
    }

    public class TitleItem
    extends Item
    implements IIgnoreSearch {
        public TitleItem(Component title) {
            super(title);
        }

        public TitleItem(String title) {
            super((Component)Component.m_237113_((String)title).m_130940_(ChatFormatting.BOLD).m_130940_(ChatFormatting.YELLOW));
        }

        @Override
        public void m_6311_(PoseStack poseStack, int x, int top, int left, int width, int height, int mouseX, int mouseY, boolean selected, float partialTicks) {
            Screen.m_93215_((PoseStack)poseStack, (Font)((ListMenuScreen)ListMenuScreen.this).f_96541_.f_91062_, (Component)this.label, (int)(left + width / 2), (int)(top + 5), (int)0xFFFFFF);
        }
    }
}

