/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard;

import com.finallion.graveyard.client.TheGraveyardClient;
import com.finallion.graveyard.config.CommonConfig;
import com.finallion.graveyard.config.GraveyardConfig;
import com.finallion.graveyard.init.TGAdvancements;
import com.finallion.graveyard.init.TGBlocks;
import com.finallion.graveyard.init.TGConfiguredStructureFeatures;
import com.finallion.graveyard.init.TGEntities;
import com.finallion.graveyard.init.TGItems;
import com.finallion.graveyard.init.TGParticles;
import com.finallion.graveyard.init.TGProcessors;
import com.finallion.graveyard.init.TGSounds;
import com.finallion.graveyard.init.TGStructureType;
import com.finallion.graveyard.init.TGTileEntities;
import com.finallion.graveyard.item.VialOfBlood;
import com.finallion.graveyard.util.SpawnRules;
import com.finallion.graveyard.util.TGTags;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.geckolib.GeckoLib;

@Mod(value="graveyard")
public class TheGraveyard {
    public static final String MOD_ID = "graveyard";
    public static final Logger LOGGER = LogManager.getLogger();

    public TheGraveyard() {
        GeckoLib.initialize();
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> TheGraveyardClient::new);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::setup);
        TGBlocks.BLOCKS.register(modEventBus);
        TGItems.ITEMS.register(modEventBus);
        TGSounds.SOUNDS.register(modEventBus);
        TGEntities.ENTITIES.register(modEventBus);
        TGConfiguredStructureFeatures.STRUCTURES.register(modEventBus);
        TGTileEntities.TILE_ENTITIES.register(modEventBus);
        TGParticles.PARTICLES.register(modEventBus);
        modEventBus.addListener(this::setupClient);
        DeferredRegister serializers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)MOD_ID);
        serializers.register(modEventBus);
        serializers.register("mobspawns", SpawnRules.ModSpawnModifier::makeCodec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)GraveyardConfig.COMMON_SPEC);
        CommonConfig.loadConfig(GraveyardConfig.COMMON_SPEC, FMLPaths.CONFIGDIR.get().resolve("graveyard-common.toml").toString());
    }

    public void setupClient(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ItemProperties.register((Item)((Item)TGItems.VIAL_OF_BLOOD.get()), (ResourceLocation)new ResourceLocation("charged"), (stack, world, entity, seed) -> {
            if (entity != null && stack.m_150930_((Item)TGItems.VIAL_OF_BLOOD.get())) {
                return VialOfBlood.getBlood(stack);
            }
            return 0.0f;
        }));
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            TGAdvancements.init();
            TGTags.init();
            TGStructureType.init();
            TGProcessors.registerProcessors();
            TGConfiguredStructureFeatures.init();
        });
    }
}

