/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.blocks;

import com.finallion.graveyard.blocks.OminousBoneStaffFragment;
import com.finallion.graveyard.config.GraveyardConfig;
import com.finallion.graveyard.entities.LichEntity;
import com.finallion.graveyard.init.TGBlocks;
import com.finallion.graveyard.init.TGEntities;
import com.finallion.graveyard.init.TGItems;
import com.finallion.graveyard.init.TGSounds;
import com.finallion.graveyard.item.VialOfBlood;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.pattern.BlockPattern;
import net.minecraft.world.level.block.state.pattern.BlockPatternBuilder;
import net.minecraft.world.level.block.state.predicate.BlockStatePredicate;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;

public class AltarBlock
extends Block {
    public static final BooleanProperty BLOODY = BooleanProperty.m_61465_((String)"bloody");
    private static BlockPattern COMPLETED_ALTAR;

    public AltarBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)BLOODY, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{BLOODY});
    }

    public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource random) {
        super.m_214162_(state, world, pos, random);
        if (((Boolean)state.m_61143_((Property)BLOODY)).booleanValue() && random.m_188503_(10) == 0) {
            world.m_7785_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, (SoundEvent)TGSounds.ALTAR_AMBIENT.get(), SoundSource.BLOCKS, 0.05f, random.m_188501_() * 0.4f + 0.8f, true);
        }
    }

    public static BlockPattern getCompletedFramePattern() {
        if (COMPLETED_ALTAR == null) {
            COMPLETED_ALTAR = BlockPatternBuilder.m_61243_().m_61247_(new String[]{"???x???", "???????", "???????", "???????", "???????", "???????", "???????", "a??b??c"}).m_61244_('?', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.f_61281_)).m_61244_('a', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)TGBlocks.LOWER_BONE_STAFF.get())).or((Predicate)BlockStatePredicate.m_61287_((Block)((Block)TGBlocks.UPPER_BONE_STAFF.get()))))).m_61244_('b', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)TGBlocks.MIDDLE_BONE_STAFF.get())))).m_61244_('c', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)TGBlocks.UPPER_BONE_STAFF.get())).or((Predicate)BlockStatePredicate.m_61287_((Block)((Block)TGBlocks.LOWER_BONE_STAFF.get()))))).m_61244_('x', BlockInWorld.m_61169_((Predicate)BlockStatePredicate.m_61287_((Block)((Block)TGBlocks.ALTAR.get())))).m_61249_();
        }
        return COMPLETED_ALTAR;
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand p_60507_, BlockHitResult p_60508_) {
        ItemStack stack = player.m_21205_();
        float blood = 0.0f;
        if (stack.m_150930_((Item)TGItems.VIAL_OF_BLOOD.get())) {
            blood = VialOfBlood.getBlood(stack);
        }
        if (state.m_60713_((Block)TGBlocks.ALTAR.get()) && (blood >= 0.8f || ((List)GraveyardConfig.COMMON.isBossSummonableItem.get()).contains(stack.m_41720_().m_5524_())) && world.m_46791_() != Difficulty.PEACEFUL && world.m_46462_()) {
            BlockPattern.BlockPatternMatch result = AltarBlock.getCompletedFramePattern().m_61184_((LevelReader)world, pos);
            if (!(((Boolean)state.m_61143_((Property)BLOODY)).booleanValue() || result == null && ((Boolean)GraveyardConfig.COMMON.summoningNeedsStaffFragments.get()).booleanValue())) {
                player.f_19853_.m_5594_(null, player.m_20183_(), (SoundEvent)TGSounds.VIAL_SPLASH.get(), SoundSource.BLOCKS, 5.0f, 1.0f);
                world.m_7731_(pos, (BlockState)state.m_61124_((Property)BLOODY, (Comparable)Boolean.valueOf(true)), 3);
                Direction direction = result == null ? Direction.NORTH : result.m_61234_();
                if (!world.m_5776_()) {
                    if (!player.m_7500_()) {
                        ItemStack bottle = new ItemStack((ItemLike)Items.f_42590_);
                        ItemUtils.m_41813_((ItemStack)stack, (Player)player, (ItemStack)bottle);
                        player.m_7292_(new MobEffectInstance(MobEffects.f_216964_, 430));
                    }
                    BlockPos corner = pos.m_7918_(-8, 0, -8);
                    for (int i = 0; i < 16; ++i) {
                        for (int j = 0; j < 16; ++j) {
                            for (int k = 0; k < 2; ++k) {
                                BlockPos iteratorPos = new BlockPos((Vec3i)corner.m_7918_(i, k, j));
                                BlockState blockState = world.m_8055_(iteratorPos);
                                if (!(blockState.m_60734_() instanceof OminousBoneStaffFragment)) continue;
                                world.m_7731_(iteratorPos, Blocks.f_50016_.m_49966_(), 3);
                            }
                        }
                    }
                    LichEntity lich = (LichEntity)((EntityType)TGEntities.LICH.get()).m_20615_(world);
                    BlockPos blockPos = pos.m_7494_();
                    lich.m_5616_(direction.m_122424_().m_122435_());
                    lich.m_5618_(direction.m_122424_().m_122435_());
                    lich.m_146922_(direction.m_122424_().m_122435_());
                    lich.m_7678_((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.55, (double)blockPos.m_123343_() + 0.5, 0.0f, 0.0f);
                    lich.onSummoned(direction.m_122424_(), pos.m_7494_());
                    for (ServerPlayer serverplayer : world.m_45976_(ServerPlayer.class, lich.m_20191_().m_82400_(50.0))) {
                        CriteriaTriggers.f_10580_.m_68256_(serverplayer, (Entity)lich);
                    }
                    world.m_7967_((Entity)lich);
                    lich.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 5));
                    return InteractionResult.CONSUME;
                }
                return InteractionResult.m_19078_((boolean)player.f_19853_.f_46443_);
            }
        }
        return super.m_6227_(state, world, pos, player, p_60507_, p_60508_);
    }
}

