/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.client;

import com.finallion.graveyard.blockentities.render.BrazierBlockEntityRenderer;
import com.finallion.graveyard.blockentities.render.GravestoneBlockEntityRenderer;
import com.finallion.graveyard.blockentities.render.SarcophagusBlockEntityRenderer;
import com.finallion.graveyard.entities.models.CorruptedIllagerModel;
import com.finallion.graveyard.entities.renders.AcolyteRender;
import com.finallion.graveyard.entities.renders.CorruptedPillagerRenderer;
import com.finallion.graveyard.entities.renders.CorruptedVindicatorRenderer;
import com.finallion.graveyard.entities.renders.FallingCorpseRenderer;
import com.finallion.graveyard.entities.renders.GhoulRenderer;
import com.finallion.graveyard.entities.renders.GhoulingRenderer;
import com.finallion.graveyard.entities.renders.LichRenderer;
import com.finallion.graveyard.entities.renders.NightmareRenderer;
import com.finallion.graveyard.entities.renders.ReaperRenderer;
import com.finallion.graveyard.entities.renders.RevenantRenderer;
import com.finallion.graveyard.entities.renders.SkeletonCreeperRender;
import com.finallion.graveyard.entities.renders.SkullEntityRenderer;
import com.finallion.graveyard.entities.renders.WraithRenderer;
import com.finallion.graveyard.init.TGBlocks;
import com.finallion.graveyard.init.TGEntities;
import com.finallion.graveyard.init.TGParticles;
import com.finallion.graveyard.init.TGTileEntities;
import com.finallion.graveyard.particles.GraveyardFogParticle;
import com.finallion.graveyard.particles.GraveyardHandParticle;
import com.finallion.graveyard.particles.GraveyardSoulParticle;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.particle.SonicBoomParticle;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class TheGraveyardClient {
    public static final ModelLayerLocation CORRUPTED_ILLAGER_MODEL_LAYER = new ModelLayerLocation(new ResourceLocation("graveyard", "corrupted_illager"), "main");

    public TheGraveyardClient() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::initParticles);
        modEventBus.addListener(this::onBlockColorsInit);
        modEventBus.addListener(this::onItemColorsInit);
        modEventBus.addListener(this::registerEntityRenderers);
        modEventBus.addListener(this::registerLayerDefinition);
        modEventBus.addListener(this::registerEntityModels);
    }

    @SubscribeEvent
    public void registerLayerDefinition(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(CORRUPTED_ILLAGER_MODEL_LAYER, CorruptedIllagerModel::createBodyModel);
    }

    @SubscribeEvent
    public void initParticles(RegisterParticleProvidersEvent event) {
        event.register((ParticleType)TGParticles.GRAVEYARD_FOG_PARTICLE.get(), GraveyardFogParticle.FogFactory::new);
        event.register((ParticleType)TGParticles.GRAVEYARD_SOUL_PARTICLE.get(), GraveyardSoulParticle.Provider::new);
        event.register((ParticleType)TGParticles.GRAVEYARD_HAND_PARTICLE.get(), GraveyardHandParticle.Provider::new);
        event.register((ParticleType)TGParticles.GRAVEYARD_LEFT_HAND_PARTICLE.get(), GraveyardHandParticle.Provider::new);
        event.register((ParticleType)TGParticles.GRAVEYARD_SOUL_BEAM_PARTICLE.get(), SonicBoomParticle.Provider::new);
    }

    @SubscribeEvent
    public void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)TGEntities.SKELETON_CREEPER.get(), SkeletonCreeperRender::new);
        event.registerEntityRenderer((EntityType)TGEntities.ACOLYTE.get(), AcolyteRender::new);
        event.registerEntityRenderer((EntityType)TGEntities.GHOUL.get(), GhoulRenderer::new);
        event.registerEntityRenderer((EntityType)TGEntities.REAPER.get(), ReaperRenderer::new);
        event.registerEntityRenderer((EntityType)TGEntities.REVENANT.get(), RevenantRenderer::new);
        event.registerEntityRenderer((EntityType)TGEntities.NIGHTMARE.get(), NightmareRenderer::new);
        event.registerEntityRenderer((EntityType)TGEntities.CORRUPTED_PILLAGER.get(), CorruptedPillagerRenderer::new);
        event.registerEntityRenderer((EntityType)TGEntities.CORRUPTED_VINDICATOR.get(), CorruptedVindicatorRenderer::new);
        event.registerEntityRenderer((EntityType)TGEntities.WRAITH.get(), WraithRenderer::new);
        event.registerEntityRenderer((EntityType)TGEntities.LICH.get(), LichRenderer::new);
        event.registerEntityRenderer((EntityType)TGEntities.FALLING_CORPSE.get(), FallingCorpseRenderer::new);
        event.registerEntityRenderer((EntityType)TGEntities.SKULL.get(), SkullEntityRenderer::new);
        event.registerEntityRenderer((EntityType)TGEntities.GHOULING.get(), GhoulingRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TGTileEntities.GRAVESTONE_BLOCK_ENTITY.get(), GravestoneBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TGTileEntities.SARCOPHAGUS_BLOCK_ENTITY.get(), SarcophagusBlockEntityRenderer::new);
        event.registerBlockEntityRenderer((BlockEntityType)TGTileEntities.BRAZIER_BLOCK_ENTITY.get(), rendererDispatcherIn -> new BrazierBlockEntityRenderer());
    }

    @SubscribeEvent
    public void onBlockColorsInit(RegisterColorHandlersEvent.Block event) {
        BlockColors blockColors = event.getBlockColors();
        blockColors.m_92589_((state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)reader, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0), new Block[]{(Block)TGBlocks.TG_GRASS_BLOCK.get()});
    }

    @SubscribeEvent
    public void onItemColorsInit(RegisterColorHandlersEvent.Item event) {
        BlockColors blockColors = event.getBlockColors();
        ItemColors itemColors = event.getItemColors();
        itemColors.m_92689_((stack, color) -> {
            BlockState blockstate = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
            return blockColors.m_92577_(blockstate, null, null, color);
        }, new ItemLike[]{(ItemLike)TGBlocks.TG_GRASS_BLOCK.get()});
    }

    @SubscribeEvent
    public void registerEntityModels(ModelEvent.RegisterAdditional event) {
        event.register(new ResourceLocation("graveyard", "item/sarcophagus_base"));
        event.register(new ResourceLocation("graveyard", "item/sarcophagus_lid"));
        for (Block block : TGBlocks.getCoffins()) {
            String woodType = block.m_7705_().split("\\.")[2];
            event.register(new ResourceLocation("graveyard", "item/" + woodType + "_base"));
            event.register(new ResourceLocation("graveyard", "item/" + woodType + "_lid"));
        }
    }
}

