/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.electronwill.nightconfig.core.io.WritingMode;
import com.finallion.graveyard.config.StructureConfigEntry;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biomes;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public final Map<String, StructureConfigEntry> structureConfigEntries = new HashMap<String, StructureConfigEntry>();
    public final ForgeConfigSpec.BooleanValue canGenerateHauntedHouse;
    public final ForgeConfigSpec.BooleanValue canGenerateMediumGraveyard;
    public final ForgeConfigSpec.BooleanValue canGenerateLargeGraveyard;
    public final ForgeConfigSpec.BooleanValue canGenerateSmallGrave;
    public final ForgeConfigSpec.BooleanValue canGenerateSmallDesertGrave;
    public final ForgeConfigSpec.BooleanValue canGenerateSmallSavannaGrave;
    public final ForgeConfigSpec.BooleanValue canGenerateSmallMountainGrave;
    public final ForgeConfigSpec.BooleanValue canGenerateSmallGraveyard;
    public final ForgeConfigSpec.BooleanValue canGenerateSmallDesertGraveyard;
    public final ForgeConfigSpec.BooleanValue canGenerateMushroomGrave;
    public final ForgeConfigSpec.BooleanValue canGenerateMemorialTree;
    public final ForgeConfigSpec.BooleanValue canGenerateAltar;
    public final ForgeConfigSpec.BooleanValue canGenerateCrypt;
    public final ForgeConfigSpec.BooleanValue canGenerateGiantMushroom;
    public final ForgeConfigSpec.BooleanValue canGenerateLichPrison;
    public final ForgeConfigSpec.BooleanValue canGenerateRuins;
    public final ForgeConfigSpec.BooleanValue enableGhoul;
    public final ForgeConfigSpec.IntValue weightGhoul;
    public final ForgeConfigSpec.IntValue minGroupSizeGhoul;
    public final ForgeConfigSpec.IntValue maxGroupSizeGhoul;
    public final ForgeConfigSpec.BooleanValue ghoulCanBurnInSunlight;
    public final ForgeConfigSpec.BooleanValue ghoulCanBeWithered;
    public final ForgeConfigSpec.BooleanValue enableRevenant;
    public final ForgeConfigSpec.IntValue weightRevenant;
    public final ForgeConfigSpec.IntValue minGroupSizeRevenant;
    public final ForgeConfigSpec.IntValue maxGroupSizeRevenant;
    public final ForgeConfigSpec.BooleanValue revenantCanBurnInSunlight;
    public final ForgeConfigSpec.BooleanValue revenantCanBeWithered;
    public final ForgeConfigSpec.BooleanValue enableReaper;
    public final ForgeConfigSpec.IntValue weightReaper;
    public final ForgeConfigSpec.IntValue minGroupSizeReaper;
    public final ForgeConfigSpec.IntValue maxGroupSizeReaper;
    public final ForgeConfigSpec.BooleanValue reaperCanBurnInSunlight;
    public final ForgeConfigSpec.BooleanValue reaperCanBeWithered;
    public final ForgeConfigSpec.BooleanValue enableNightmare;
    public final ForgeConfigSpec.IntValue weightNightmare;
    public final ForgeConfigSpec.IntValue minGroupSizeNightmare;
    public final ForgeConfigSpec.IntValue maxGroupSizeNightmare;
    public final ForgeConfigSpec.BooleanValue nightmareCanBurnInSunlight;
    public final ForgeConfigSpec.BooleanValue nightmareCanBeWithered;
    public final ForgeConfigSpec.BooleanValue enableSkeletonCreeper;
    public final ForgeConfigSpec.IntValue weightSkeletonCreeper;
    public final ForgeConfigSpec.IntValue minGroupSizeSkeletonCreeper;
    public final ForgeConfigSpec.IntValue maxGroupSizeSkeletonCreeper;
    public final ForgeConfigSpec.BooleanValue skeletonCreeperCanBurnInSunlight;
    public final ForgeConfigSpec.BooleanValue skeletonCreeperCanBeWithered;
    public final ForgeConfigSpec.BooleanValue enableAcolyte;
    public final ForgeConfigSpec.IntValue weightAcolyte;
    public final ForgeConfigSpec.IntValue minGroupSizeAcolyte;
    public final ForgeConfigSpec.IntValue maxGroupSizeAcolyte;
    public final ForgeConfigSpec.BooleanValue acolyteCanBurnInSunlight;
    public final ForgeConfigSpec.BooleanValue acolyteCanBeWithered;
    public final ForgeConfigSpec.BooleanValue enableWraith;
    public final ForgeConfigSpec.IntValue weightWraith;
    public final ForgeConfigSpec.IntValue minGroupSizeWraith;
    public final ForgeConfigSpec.IntValue maxGroupSizeWraith;
    public final ForgeConfigSpec.BooleanValue wraithCanBurnInSunlight;
    public final ForgeConfigSpec.BooleanValue wraithCanBeWithered;
    public final ForgeConfigSpec.BooleanValue enableCorruptedPillager;
    public final ForgeConfigSpec.IntValue weightCorruptedPillager;
    public final ForgeConfigSpec.IntValue minGroupSizeCorruptedPillager;
    public final ForgeConfigSpec.IntValue maxGroupSizeCorruptedPillager;
    public final ForgeConfigSpec.BooleanValue corruptedPillagerCanBurnInSunlight;
    public final ForgeConfigSpec.BooleanValue corruptedPillagerCanBeWithered;
    public final ForgeConfigSpec.BooleanValue enableCorruptedVindicator;
    public final ForgeConfigSpec.IntValue weightCorruptedVindicator;
    public final ForgeConfigSpec.IntValue minGroupSizeCorruptedVindicator;
    public final ForgeConfigSpec.IntValue maxGroupSizeCorruptedVindicator;
    public final ForgeConfigSpec.BooleanValue corruptedVindicatorCanBurnInSunlight;
    public final ForgeConfigSpec.BooleanValue corruptedVindicatorCanBeWithered;
    public final ForgeConfigSpec.BooleanValue enableHorde;
    public final ForgeConfigSpec.IntValue mobSpawnAttempts;
    public final ForgeConfigSpec.IntValue ticksUntilSpawnHorde;
    public final ForgeConfigSpec.IntValue additionalRandomizedTicks;
    public final ForgeConfigSpec.BooleanValue enableMossParticle;
    public final ForgeConfigSpec.IntValue particleFrequency;
    public final ForgeConfigSpec.BooleanValue urnHasDoubleInventory;
    public final ForgeConfigSpec.BooleanValue disableWitherSkeletonSpawner;
    public final ForgeConfigSpec.IntValue maxTerrainHeightDifference;
    public final ForgeConfigSpec.DoubleValue healthInCastingPhase;
    public final ForgeConfigSpec.DoubleValue healthInHuntingPhase;
    public final ForgeConfigSpec.DoubleValue damageCastingPhase;
    public final ForgeConfigSpec.DoubleValue damageHuntingPhaseAddition;
    public final ForgeConfigSpec.DoubleValue armor;
    public final ForgeConfigSpec.DoubleValue armorToughness;
    public final ForgeConfigSpec.DoubleValue speedInHuntPhase;
    public final ForgeConfigSpec.IntValue durationHuntingPhase;
    public final ForgeConfigSpec.IntValue durationFallingCorpseSpell;
    public final ForgeConfigSpec.IntValue durationHealingSpell;
    public final ForgeConfigSpec.IntValue durationLevitationSpell;
    public final ForgeConfigSpec.IntValue maxAmountSkullsInShootSkullSpell;
    public final ForgeConfigSpec.IntValue maxSummonedMobs;
    public final ForgeConfigSpec.IntValue maxGroupSizeSummonedMobs;
    public final ForgeConfigSpec.IntValue ghoulSpawnTimerInFight;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> isBloodCollectableEntity;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> isBossSummonableItem;
    public final ForgeConfigSpec.BooleanValue summoningNeedsStaffFragments;
    public final ForgeConfigSpec.BooleanValue isMultiphaseFight;
    public final ForgeConfigSpec.BooleanValue isInvulnerableDuringSpells;

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.comment(" Welcome to The Graveyard Config!\nStructures:\nEnable or disable structure generation.\n\nMobs:\nEnable or disable mob spawns.\nConfigure if mobs burn in sunlight and/or if mobs are affected by the wither effect.\nAdditional:\nConfigure graveyard fog particles rising from moss and set the chance of spawning them (higher numbers = lower chance of spawning).\nConfigure if hordes of graveyard mobs can spawn and set their size and frequency.\nConfigure if urns have a double chest inventory.\nConfigure if the wither skeleton spawner in the large graveyard will be replaced by a skeleton spawner.\n");
        builder.push("The Graveyard - Structures Config");
        this.canGenerateHauntedHouse = builder.define("hauntedHouse.generate", true);
        this.canGenerateLargeGraveyard = builder.define("largeGraveyard.generate", true);
        this.canGenerateMediumGraveyard = builder.define("mediumGraveyard.generate", true);
        this.canGenerateMemorialTree = builder.define("memorialTree.generate", true);
        this.canGenerateMushroomGrave = builder.define("mushroomGrave.generate", true);
        this.canGenerateSmallDesertGrave = builder.define("smallDesertGrave.generate", true);
        this.canGenerateSmallDesertGraveyard = builder.define("smallDesertGraveyard.generate", true);
        this.canGenerateSmallGrave = builder.define("smallGrave.generate", true);
        this.canGenerateSmallSavannaGrave = builder.define("smallSavannaGrave.generate", true);
        this.canGenerateSmallGraveyard = builder.define("smallGraveyard.generate", true);
        this.canGenerateSmallMountainGrave = builder.define("smallMountainGraveyard.generate", true);
        this.canGenerateCrypt = builder.define("crypt.generate", true);
        this.canGenerateAltar = builder.define("altar.generate", true);
        this.canGenerateGiantMushroom = builder.define("giantMushroom.generate", true);
        this.canGenerateLichPrison = builder.define("lichPrison.generate", true);
        this.canGenerateRuins = builder.define("ruins.generate", true);
        builder.pop();
        builder.push("The Graveyard - Mob Spawning Config");
        this.enableGhoul = builder.define("ghoul.enabled", true);
        this.weightGhoul = builder.defineInRange("ghoul.weight", 25, 0, 100);
        this.minGroupSizeGhoul = builder.defineInRange("ghoul.minGroupSizeGhoul", 2, 1, 100);
        this.maxGroupSizeGhoul = builder.defineInRange("ghoul.maxGroupSizeGhoul", 5, 1, 100);
        this.ghoulCanBurnInSunlight = builder.define("ghoul.canBurnInSunlight", true);
        this.ghoulCanBeWithered = builder.define("ghoul.canBeWithered", false);
        this.enableRevenant = builder.define("revenant.enabled", true);
        this.weightRevenant = builder.defineInRange("revenant.weight", 25, 0, 100);
        this.minGroupSizeRevenant = builder.defineInRange("revenant.minGroupSizeRevenant", 5, 1, 100);
        this.maxGroupSizeRevenant = builder.defineInRange("revenant.maxGroupSizeRevenant", 8, 1, 100);
        this.revenantCanBurnInSunlight = builder.define("revenant.canBurnInSunlight", true);
        this.revenantCanBeWithered = builder.define("revenant.canBeWithered", false);
        this.enableReaper = builder.define("reaper.enabled", true);
        this.weightReaper = builder.defineInRange("reaper.weight", 10, 0, 100);
        this.minGroupSizeReaper = builder.defineInRange("reaper.minGroupSizeReaper", 2, 1, 100);
        this.maxGroupSizeReaper = builder.defineInRange("reaper.maxGroupSizeGhoul", 3, 1, 100);
        this.reaperCanBurnInSunlight = builder.define("reaper.canBurnInSunlight", true);
        this.reaperCanBeWithered = builder.define("reaper.canBeWithered", false);
        this.enableNightmare = builder.define("nightmare.enabled", true);
        this.weightNightmare = builder.defineInRange("nightmare.weight", 7, 0, 100);
        this.minGroupSizeNightmare = builder.defineInRange("nightmare.minGroupSizeNightmare", 1, 1, 100);
        this.maxGroupSizeNightmare = builder.defineInRange("nightmare.maxGroupSizeNightmare", 1, 1, 100);
        this.nightmareCanBurnInSunlight = builder.define("nightmare.canBurnInSunlight", false);
        this.nightmareCanBeWithered = builder.define("nightmare.canBeWithered", false);
        this.enableSkeletonCreeper = builder.define("skeleton_creeper.enabled", true);
        this.weightSkeletonCreeper = builder.defineInRange("skeleton_creeper.weight", 20, 0, 100);
        this.minGroupSizeSkeletonCreeper = builder.defineInRange("skeleton_creeper.minGroupSizeSkeletonCreeper", 1, 1, 100);
        this.maxGroupSizeSkeletonCreeper = builder.defineInRange("skeleton_creeper.maxGroupSizeSkeletonCreeper", 4, 1, 100);
        this.skeletonCreeperCanBurnInSunlight = builder.define("skeleton_creeper.canBurnInSunlight", true);
        this.skeletonCreeperCanBeWithered = builder.define("skeleton_creeper.canBeWithered", false);
        this.enableAcolyte = builder.define("acolyte.enabled", false);
        this.weightAcolyte = builder.defineInRange("acolyte.weight", 0, 0, 100);
        this.minGroupSizeAcolyte = builder.defineInRange("acolyte.minGroupSizeAcolyte", 2, 1, 100);
        this.maxGroupSizeAcolyte = builder.defineInRange("acolyte.maxGroupSizeAcolyte", 3, 1, 100);
        this.acolyteCanBurnInSunlight = builder.define("acolyte.canBurnInSunlight", false);
        this.acolyteCanBeWithered = builder.define("acolyte.canBeWithered", false);
        this.enableWraith = builder.define("wraith.enabled", false);
        this.weightWraith = builder.defineInRange("wraith.weight", 0, 0, 100);
        this.minGroupSizeWraith = builder.defineInRange("wraith.minGroupSizeWraith", 2, 1, 100);
        this.maxGroupSizeWraith = builder.defineInRange("wraith.maxGroupSizeWraith", 3, 1, 100);
        this.wraithCanBurnInSunlight = builder.define("wraith.canBurnInSunlight", true);
        this.wraithCanBeWithered = builder.define("wraith.canBeWithered", false);
        this.enableCorruptedPillager = builder.define("corruptedPillager.enabled", false);
        this.weightCorruptedPillager = builder.defineInRange("corruptedPillager.weight", 0, 0, 100);
        this.minGroupSizeCorruptedPillager = builder.defineInRange("corruptedPillager.minGroupSizeCorruptedPillager", 2, 1, 100);
        this.maxGroupSizeCorruptedPillager = builder.defineInRange("corruptedPillager.maxGroupSizeCorruptedPillager", 3, 1, 100);
        this.corruptedPillagerCanBurnInSunlight = builder.define("corruptedPillager.canBurnInSunlight", true);
        this.corruptedPillagerCanBeWithered = builder.define("corruptedPillager.canBeWithered", false);
        this.enableCorruptedVindicator = builder.define("corruptedVindicator.enabled", false);
        this.weightCorruptedVindicator = builder.defineInRange("corruptedVindicator.weight", 0, 0, 100);
        this.minGroupSizeCorruptedVindicator = builder.defineInRange("corruptedVindicator.minGroupSizeCorruptedVindicator", 2, 1, 100);
        this.maxGroupSizeCorruptedVindicator = builder.defineInRange("corruptedVindicator.maxGroupSizeCorruptedVindicator", 3, 1, 100);
        this.corruptedVindicatorCanBurnInSunlight = builder.define("corruptedVindicator.canBurnInSunlight", true);
        this.corruptedVindicatorCanBeWithered = builder.define("corruptedVindicator.canBeWithered", false);
        builder.pop();
        builder.push("The Graveyard - Corrupted Champion Config");
        this.healthInCastingPhase = builder.defineInRange("corruptedChampion.healthInCastingPhase", 400.0, 1.0, 1024.0);
        this.healthInHuntingPhase = builder.defineInRange("corruptedChampion.healthInHuntingPhase", 200.0, 1.0, 1024.0);
        this.damageCastingPhase = builder.defineInRange("corruptedChampion.damageCastingPhase", 30.0, 1.0, 2048.0);
        this.damageHuntingPhaseAddition = builder.defineInRange("corruptedChampion.damageHuntingPhaseAddition", 40.0, 1.0, 2048.0);
        this.armor = builder.defineInRange("corruptedChampion.armor", 18.0, 0.0, 30.0);
        this.armorToughness = builder.defineInRange("corruptedChampion.armorToughness", 14.0, 0.0, 20.0);
        this.speedInHuntPhase = builder.defineInRange("corruptedChampion.speedInHuntPhase", 0.15, 0.0, 1024.0);
        this.durationHuntingPhase = builder.defineInRange("corruptedChampion.durationHuntingPhase", 800, 1, 100000);
        this.durationFallingCorpseSpell = builder.defineInRange("corruptedChampion.durationFallingCorpseSpell", 400, 1, 100000);
        this.durationHealingSpell = builder.defineInRange("corruptedChampion.durationHealingSpell", 700, 1, 100000);
        this.durationLevitationSpell = builder.defineInRange("corruptedChampion.durationLevitationSpell", 150, 1, 100000);
        this.maxAmountSkullsInShootSkullSpell = builder.defineInRange("corruptedChampion.maxAmountSkullsInShootSkullSpell", 5, 1, 100);
        this.maxSummonedMobs = builder.defineInRange("corruptedChampion.maxSummonedMobs", 30, 0, 100);
        this.maxGroupSizeSummonedMobs = builder.defineInRange("corruptedChampion.maxGroupSizeSummonedMobs", 5, 1, 100);
        this.ghoulSpawnTimerInFight = builder.defineInRange("corruptedChampion.ghoulSpawnTimerInFight", 6000, 0, 100000);
        this.isBloodCollectableEntity = builder.defineList("corruptedChampion.isBloodCollectableEntity", List.of("entity.minecraft.villager"), o -> o instanceof String);
        this.isBossSummonableItem = builder.defineList("corruptedChampion.isBossSummonableItem", List.of("item.minecraft.debug_stick"), o -> o instanceof String);
        this.summoningNeedsStaffFragments = builder.define("corruptedChampion.summoningNeedsStaffFragments", true);
        this.isMultiphaseFight = builder.define("corruptedChampion.isMultiphaseFight", true);
        this.isInvulnerableDuringSpells = builder.define("corruptedChampion.isInvulnerableDuringSpells", true);
        builder.pop();
        builder.push("The Graveyard - Horde Config");
        this.enableHorde = builder.define("horde.generate", true);
        this.mobSpawnAttempts = builder.defineInRange("horde.mobSpawnAttempts", 40, 0, 1000);
        this.ticksUntilSpawnHorde = builder.defineInRange("horde.ticksUntilSpawnHorde", 24000, 1, 1000000);
        this.additionalRandomizedTicks = builder.defineInRange("horde.additionalRandomizedTicks", 1200, 1, 1000000);
        builder.pop();
        builder.push("The Graveyard - Particle Config");
        this.enableMossParticle = builder.define("particle.generate", true);
        this.particleFrequency = builder.defineInRange("particle.frequency", 50, 1, 500);
        builder.pop();
        builder.push("The Graveyard - Additional Config");
        this.urnHasDoubleInventory = builder.define("urn.urnHasDoubleInventory", true);
        this.disableWitherSkeletonSpawner = builder.define("spawner.disableWitherSkeletonSpawner", false);
        this.maxTerrainHeightDifference = builder.defineInRange("terrain.maxTerrainHeightDifference", 5, 1, 100);
        builder.pop();
    }

    private List<String> getMobBlacklist() {
        HashSet<ResourceKey> biomes = new HashSet<ResourceKey>();
        biomes.add(Biomes.f_220594_);
        biomes.add(Biomes.f_48215_);
        biomes.add(Biomes.f_48179_);
        return new ArrayList<String>(biomes.stream().map(value -> value.m_135782_().toString()).toList());
    }

    public static void loadConfig(ForgeConfigSpec config, String path) {
        CommentedFileConfig file = (CommentedFileConfig)CommentedFileConfig.builder((File)new File(path)).sync().autosave().writingMode(WritingMode.REPLACE).build();
        file.load();
        config.setConfig((CommentedConfig)file);
    }
}

