/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.players.OldUsersConverter;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import org.jetbrains.annotations.Nullable;

public class GraveyardMinionEntity
extends PathfinderMob {
    protected static final EntityDataAccessor<Optional<UUID>> OWNER_UUID = SynchedEntityData.m_135353_(GraveyardMinionEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135041_);

    public GraveyardMinionEntity(EntityType<? extends GraveyardMinionEntity> entityType, Level world) {
        super(entityType, world);
        this.m_21441_(BlockPathTypes.POWDER_SNOW, -1.0f);
        this.m_21441_(BlockPathTypes.DANGER_POWDER_SNOW, -1.0f);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(OWNER_UUID, Optional.empty());
    }

    public void m_7380_(CompoundTag nbt) {
        super.m_7380_(nbt);
        if (this.getOwnerUuid() != null) {
            nbt.m_128362_("Owner", this.getOwnerUuid());
        }
    }

    public void m_7378_(CompoundTag nbt) {
        UUID uUID;
        super.m_7378_(nbt);
        if (nbt.m_128441_("Owner")) {
            uUID = nbt.m_128342_("Owner");
        } else {
            String string = nbt.m_128461_("Owner");
            uUID = OldUsersConverter.m_11083_((MinecraftServer)this.m_20194_(), (String)string);
        }
        if (uUID != null) {
            try {
                this.setOwnerUuid(uUID);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    @Nullable
    public UUID getOwnerUuid() {
        return ((Optional)this.f_19804_.m_135370_(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUuid(@Nullable UUID uuid) {
        this.f_19804_.m_135381_(OWNER_UUID, Optional.ofNullable(uuid));
    }

    public void setOwner(Player player) {
        this.setOwnerUuid(player.m_20148_());
    }

    @Nullable
    public LivingEntity getOwner() {
        try {
            UUID uUID = this.getOwnerUuid();
            return uUID == null ? null : this.f_19853_.m_46003_(uUID);
        }
        catch (IllegalArgumentException var2) {
            return null;
        }
    }

    public boolean m_6779_(LivingEntity p_21822_) {
        return this.isOwner(p_21822_) ? false : super.m_6779_(p_21822_);
    }

    public boolean isOwner(LivingEntity entity) {
        return entity == this.getOwner();
    }

    public boolean m_7307_(Entity p_21833_) {
        LivingEntity livingentity = this.getOwner();
        if (p_21833_ == livingentity) {
            return true;
        }
        if (livingentity != null) {
            return livingentity.m_7307_(p_21833_);
        }
        return super.m_7307_(p_21833_);
    }

    public boolean wantsToAttack(LivingEntity p_30389_, LivingEntity p_30390_) {
        if (!(p_30389_ instanceof Creeper) && !(p_30389_ instanceof Ghast)) {
            if (p_30389_ instanceof Wolf) {
                Wolf wolf = (Wolf)p_30389_;
                return !wolf.m_21824_() || wolf.m_21826_() != p_30390_;
            }
            if (p_30389_ instanceof Player && p_30390_ instanceof Player && !((Player)p_30390_).m_7099_((Player)p_30389_)) {
                return false;
            }
            if (p_30389_ instanceof AbstractHorse && ((AbstractHorse)p_30389_).m_30614_()) {
                return false;
            }
            return !(p_30389_ instanceof TamableAnimal) || !((TamableAnimal)p_30389_).m_21824_();
        }
        return false;
    }
}

