/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities;

import com.finallion.graveyard.entities.HostileGraveyardEntity;
import com.finallion.graveyard.init.TGAdvancements;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class HordeGraveyardEntity
extends HostileGraveyardEntity {
    @javax.annotation.Nullable
    private BlockPos patrolTarget;
    private boolean patrolLeader;
    private boolean patrolling;

    protected HordeGraveyardEntity(EntityType<? extends Monster> entityType, Level world, String name) {
        super(entityType, world, name);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(4, new LongDistancePatrolGoal<HordeGraveyardEntity>(this, 1.0, 0.9));
    }

    public void m_7380_(CompoundTag p_33063_) {
        super.m_7380_(p_33063_);
        if (this.patrolTarget != null) {
            p_33063_.m_128365_("PatrolTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.patrolTarget));
        }
        p_33063_.m_128379_("PatrolLeader", this.patrolLeader);
        p_33063_.m_128379_("Patrolling", this.patrolling);
    }

    public void m_7378_(CompoundTag p_33055_) {
        super.m_7378_(p_33055_);
        if (p_33055_.m_128441_("PatrolTarget")) {
            this.patrolTarget = NbtUtils.m_129239_((CompoundTag)p_33055_.m_128469_("PatrolTarget"));
        }
        this.patrolLeader = p_33055_.m_128471_("PatrolLeader");
        this.patrolling = p_33055_.m_128471_("Patrolling");
    }

    public double m_6049_() {
        return -0.45;
    }

    public boolean canBeLeader() {
        return true;
    }

    @javax.annotation.Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_33049_, DifficultyInstance p_33050_, MobSpawnType p_33051_, @javax.annotation.Nullable SpawnGroupData p_33052_, @javax.annotation.Nullable CompoundTag p_33053_) {
        if (p_33051_ != MobSpawnType.PATROL && p_33051_ != MobSpawnType.EVENT && p_33051_ != MobSpawnType.STRUCTURE && this.f_19796_.m_188501_() < 0.06f && this.canBeLeader()) {
            this.patrolLeader = true;
        }
        if (p_33051_ == MobSpawnType.PATROL) {
            this.patrolling = true;
        }
        return super.m_6518_(p_33049_, p_33050_, p_33051_, p_33052_, p_33053_);
    }

    public boolean m_6785_(double p_33073_) {
        return !this.patrolling || p_33073_ > 16384.0;
    }

    public void setPatrolTarget(BlockPos p_33071_) {
        this.patrolTarget = p_33071_;
        this.patrolling = true;
    }

    public BlockPos getPatrolTarget() {
        return this.patrolTarget;
    }

    public boolean hasPatrolTarget() {
        return this.patrolTarget != null;
    }

    public void setPatrolLeader(boolean p_33076_) {
        this.patrolLeader = p_33076_;
        this.patrolling = true;
    }

    public boolean isPatrolLeader() {
        return this.patrolLeader;
    }

    public boolean canJoinPatrol() {
        return true;
    }

    public void findPatrolTarget() {
        this.patrolTarget = this.m_20183_().m_7918_(-500 + this.f_19796_.m_188503_(1000), 0, -500 + this.f_19796_.m_188503_(1000));
        this.patrolling = true;
    }

    protected boolean isPatrolling() {
        return this.patrolling;
    }

    protected void setPatrolling(boolean p_33078_) {
        this.patrolling = p_33078_;
    }

    public void m_21268_(@Nullable LivingEntity adversary) {
        if (adversary instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)adversary;
            if (this.patrolLeader) {
                TGAdvancements.KILL_HORDE.trigger(player);
            }
        }
        super.m_6703_(adversary);
    }

    public static class LongDistancePatrolGoal<T extends HordeGraveyardEntity>
    extends Goal {
        private final T mob;
        private final double speedModifier;
        private final double leaderSpeedModifier;
        private long cooldownUntil;

        public LongDistancePatrolGoal(T p_33084_, double p_33085_, double p_33086_) {
            this.mob = p_33084_;
            this.speedModifier = p_33085_;
            this.leaderSpeedModifier = p_33086_;
            this.cooldownUntil = -1L;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            boolean flag = ((HordeGraveyardEntity)((Object)this.mob)).f_19853_.m_46467_() < this.cooldownUntil;
            return ((HordeGraveyardEntity)((Object)this.mob)).isPatrolling() && this.mob.m_5448_() == null && !this.mob.m_20160_() && ((HordeGraveyardEntity)((Object)this.mob)).hasPatrolTarget() && !flag;
        }

        public void m_8056_() {
        }

        public void m_8041_() {
        }

        public void m_8037_() {
            boolean flag = ((HordeGraveyardEntity)((Object)this.mob)).isPatrolLeader();
            PathNavigation pathnavigation = this.mob.m_21573_();
            if (pathnavigation.m_26571_()) {
                List<HordeGraveyardEntity> list = this.findPatrolCompanions();
                if (((HordeGraveyardEntity)((Object)this.mob)).isPatrolling() && list.isEmpty()) {
                    ((HordeGraveyardEntity)((Object)this.mob)).setPatrolling(false);
                } else if (flag && ((HordeGraveyardEntity)((Object)this.mob)).getPatrolTarget().m_203195_((Position)this.mob.m_20182_(), 10.0)) {
                    ((HordeGraveyardEntity)((Object)this.mob)).findPatrolTarget();
                } else {
                    Vec3 vec3 = Vec3.m_82539_((Vec3i)((HordeGraveyardEntity)((Object)this.mob)).getPatrolTarget());
                    Vec3 vec31 = this.mob.m_20182_();
                    Vec3 vec32 = vec31.m_82546_(vec3);
                    vec3 = vec32.m_82524_(90.0f).m_82490_(0.4).m_82549_(vec3);
                    Vec3 vec33 = vec3.m_82546_(vec31).m_82541_().m_82490_(10.0).m_82549_(vec31);
                    BlockPos blockpos = new BlockPos(vec33);
                    if (!pathnavigation.m_26519_((double)(blockpos = ((HordeGraveyardEntity)((Object)this.mob)).f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockpos)).m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), flag ? this.leaderSpeedModifier : this.speedModifier)) {
                        this.moveRandomly();
                        this.cooldownUntil = ((HordeGraveyardEntity)((Object)this.mob)).f_19853_.m_46467_() + 200L;
                    } else if (flag) {
                        for (HordeGraveyardEntity patrollingmonster : list) {
                            patrollingmonster.setPatrolTarget(blockpos);
                        }
                    }
                }
            }
        }

        private List<HordeGraveyardEntity> findPatrolCompanions() {
            return ((HordeGraveyardEntity)((Object)this.mob)).f_19853_.m_6443_(HordeGraveyardEntity.class, this.mob.m_20191_().m_82400_(16.0), p_33089_ -> p_33089_.canJoinPatrol() && !p_33089_.m_7306_((Entity)this.mob));
        }

        private boolean moveRandomly() {
            RandomSource random = this.mob.m_217043_();
            BlockPos blockpos = ((HordeGraveyardEntity)((Object)this.mob)).f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, this.mob.m_20183_().m_7918_(-8 + random.m_188503_(16), 0, -8 + random.m_188503_(16)));
            return this.mob.m_21573_().m_26519_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), this.speedModifier);
        }
    }
}

