/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities;

import com.finallion.graveyard.config.GraveyardConfig;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class HostileGraveyardEntity
extends Monster {
    private String name;
    private static final EntityDataAccessor<Boolean> CAN_BURN_IN_SUNLIGHT = SynchedEntityData.m_135353_(HostileGraveyardEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public HostileGraveyardEntity(EntityType<? extends Monster> entityType, Level world, String name) {
        super(entityType, world);
        this.name = name;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(CAN_BURN_IN_SUNLIGHT, (Object)true);
        super.m_8097_();
    }

    protected boolean m_21527_() {
        return super.m_21527_();
    }

    protected boolean isSunSensitive() {
        return true;
    }

    private boolean canBurnInSunlight() {
        return (Boolean)this.f_19804_.m_135370_(CAN_BURN_IN_SUNLIGHT);
    }

    public void setCanBurnInSunlight(boolean bool) {
        this.f_19804_.m_135381_(CAN_BURN_IN_SUNLIGHT, (Object)bool);
    }

    private boolean getSunBurnConfigBoolean(String name) {
        switch (name) {
            case "acolyte": {
                return (Boolean)GraveyardConfig.COMMON.acolyteCanBurnInSunlight.get();
            }
            case "ghoul": {
                return (Boolean)GraveyardConfig.COMMON.ghoulCanBurnInSunlight.get();
            }
            case "reaper": {
                return (Boolean)GraveyardConfig.COMMON.reaperCanBurnInSunlight.get();
            }
            case "revenant": {
                return (Boolean)GraveyardConfig.COMMON.revenantCanBurnInSunlight.get();
            }
            case "skeleton_creeper": {
                return (Boolean)GraveyardConfig.COMMON.skeletonCreeperCanBurnInSunlight.get();
            }
            case "wraith": {
                return (Boolean)GraveyardConfig.COMMON.wraithCanBurnInSunlight.get();
            }
            case "nightmare": {
                return (Boolean)GraveyardConfig.COMMON.nightmareCanBurnInSunlight.get();
            }
            case "corrupted_pillager": {
                return (Boolean)GraveyardConfig.COMMON.corruptedPillagerCanBurnInSunlight.get();
            }
            case "corrupted_vindicator": {
                return (Boolean)GraveyardConfig.COMMON.corruptedVindicatorCanBurnInSunlight.get();
            }
        }
        return false;
    }

    private boolean getWitherConfigBoolean(String name) {
        switch (name) {
            case "acolyte": {
                return (Boolean)GraveyardConfig.COMMON.acolyteCanBeWithered.get();
            }
            case "ghoul": {
                return (Boolean)GraveyardConfig.COMMON.ghoulCanBeWithered.get();
            }
            case "reaper": {
                return (Boolean)GraveyardConfig.COMMON.reaperCanBeWithered.get();
            }
            case "revenant": {
                return (Boolean)GraveyardConfig.COMMON.revenantCanBeWithered.get();
            }
            case "skeleton_creeper": {
                return (Boolean)GraveyardConfig.COMMON.skeletonCreeperCanBeWithered.get();
            }
            case "wraith": {
                return (Boolean)GraveyardConfig.COMMON.wraithCanBeWithered.get();
            }
            case "nightmare": {
                return (Boolean)GraveyardConfig.COMMON.nightmareCanBeWithered.get();
            }
            case "corrupted_pillager": {
                return (Boolean)GraveyardConfig.COMMON.corruptedPillagerCanBeWithered.get();
            }
            case "corrupted_vindicator": {
                return (Boolean)GraveyardConfig.COMMON.corruptedVindicatorCanBeWithered.get();
            }
        }
        return false;
    }

    public boolean m_7301_(MobEffectInstance effect) {
        if (effect.m_19544_() == MobEffects.f_19615_) {
            return this.getWitherConfigBoolean(this.name);
        }
        return super.m_7301_(effect);
    }

    public void m_8107_() {
        if (this.m_6084_()) {
            boolean flag;
            boolean bl = flag = this.isSunSensitive() && this.m_21527_() && this.getSunBurnConfigBoolean(this.name) && this.canBurnInSunlight();
            if (flag) {
                ItemStack itemstack = this.m_6844_(EquipmentSlot.HEAD);
                if (!itemstack.m_41619_()) {
                    if (itemstack.m_41763_()) {
                        itemstack.m_41721_(itemstack.m_41773_() + this.f_19796_.m_188503_(2));
                        if (itemstack.m_41773_() >= itemstack.m_41776_()) {
                            this.m_21166_(EquipmentSlot.HEAD);
                            this.m_8061_(EquipmentSlot.HEAD, ItemStack.f_41583_);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.m_20254_(8);
                }
            }
        }
        super.m_8107_();
    }
}

