/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities.ai.goals;

import com.finallion.graveyard.entities.GhoulEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.pathfinder.Path;

public class GhoulMeleeAttackGoal
extends Goal {
    protected final GhoulEntity mob;
    private final double speed;
    private final boolean pauseWhenMobIdle;
    private Path path;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int updateCountdownTicks;
    private int cooldown;
    private final int attackIntervalTicks = 15;
    private long lastUpdateTime;
    private final int DAMAGE_START_IN_ANIM = 12;
    private int animationTicker = 14;
    private boolean canFinishAttack = false;

    public GhoulMeleeAttackGoal(GhoulEntity mob, double speed, boolean pauseWhenMobIdle) {
        this.mob = mob;
        this.speed = speed;
        this.pauseWhenMobIdle = pauseWhenMobIdle;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long l = this.mob.f_19853_.m_46467_();
        if (l - this.lastUpdateTime < 20L) {
            this.lastUpdateTime -= 20L;
            return this.m_8036_();
        }
        this.lastUpdateTime = l;
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        this.path = this.mob.m_21573_().m_6570_((Entity)livingEntity, 0);
        if (this.path != null) {
            return true;
        }
        return this.getSquaredMaxAttackDistance(livingEntity) >= this.mob.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
    }

    public boolean m_8045_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity == null) {
            return false;
        }
        if (!livingEntity.m_6084_()) {
            return false;
        }
        if (!this.pauseWhenMobIdle) {
            return !this.mob.m_21573_().m_26571_();
        }
        if (!this.mob.m_21444_(livingEntity.m_20183_())) {
            return false;
        }
        return !(livingEntity instanceof Player) || !livingEntity.m_5833_() && !((Player)livingEntity).m_7500_();
    }

    public void m_8056_() {
        this.mob.m_21573_().m_26536_(this.path, this.speed);
        this.mob.m_21561_(true);
        this.updateCountdownTicks = 0;
        this.cooldown = 0;
    }

    public void m_8041_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(livingEntity)) {
            this.mob.m_6710_(null);
        }
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity livingEntity = this.mob.m_5448_();
        if (livingEntity != null) {
            this.mob.m_21563_().m_24960_((Entity)livingEntity, 30.0f, 30.0f);
            double d = this.mob.m_20275_(livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_());
            this.updateCountdownTicks = Math.max(this.updateCountdownTicks - 1, 0);
            if ((this.pauseWhenMobIdle || this.mob.m_21574_().m_148306_((Entity)livingEntity)) && this.updateCountdownTicks <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || livingEntity.m_20275_(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.mob.m_217043_().m_188501_() < 0.05f)) {
                this.targetX = livingEntity.m_20185_();
                this.targetY = livingEntity.m_20186_();
                this.targetZ = livingEntity.m_20189_();
                this.updateCountdownTicks = 4 + this.mob.m_217043_().m_188503_(7);
                if (d > 1024.0) {
                    this.updateCountdownTicks += 10;
                } else if (d > 256.0) {
                    this.updateCountdownTicks += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)livingEntity, this.speed)) {
                    this.updateCountdownTicks += 15;
                }
                this.updateCountdownTicks = this.m_183277_(this.updateCountdownTicks);
            }
            this.cooldown = Math.max(this.cooldown - 1, 0);
            --this.animationTicker;
            this.attack(livingEntity, d);
        }
    }

    protected void attack(LivingEntity target, double squaredDistance) {
        double d = this.getSquaredMaxAttackDistance(target);
        if (squaredDistance <= d && this.cooldown <= 0) {
            this.resetCooldown(20);
            if (this.mob.getAttackAnimTimer() == 0) {
                this.mob.setAttackAnimTimer(this.mob.ATTACK_ANIMATION_DURATION);
                this.animationTicker = this.mob.ATTACK_ANIMATION_DURATION;
                this.canFinishAttack = true;
            }
        }
        if (this.canFinishAttack && this.animationTicker == 12) {
            this.mob.m_7327_((Entity)target);
            this.canFinishAttack = false;
        }
    }

    protected double getSquaredMaxAttackDistance(LivingEntity entity) {
        return this.mob.m_20205_() * 2.0f * this.mob.m_20205_() * 2.0f + entity.m_20205_();
    }

    protected void resetCooldown(int ticks) {
        this.cooldown = this.m_183277_(ticks);
    }
}

