/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.entities.horde;

import com.finallion.graveyard.config.GraveyardConfig;
import com.finallion.graveyard.entities.HordeGraveyardEntity;
import com.finallion.graveyard.entities.HostileGraveyardEntity;
import com.finallion.graveyard.init.TGEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.ForgeHooks;

public class GraveyardHordeSpawner {
    private int nextTick;

    public GraveyardHordeSpawner(MinecraftServer server) {
    }

    public int tick(Level level) {
        if (!((Boolean)GraveyardConfig.COMMON.enableHorde.get()).booleanValue()) {
            return 0;
        }
        RandomSource random = level.f_46441_;
        --this.nextTick;
        if (this.nextTick > 0) {
            return 0;
        }
        this.nextTick += (Integer)GraveyardConfig.COMMON.ticksUntilSpawnHorde.get() + (Integer)GraveyardConfig.COMMON.additionalRandomizedTicks.get();
        if (level.m_46462_()) {
            if (random.m_188503_(5) != 0) {
                return 0;
            }
            int j = level.m_6907_().size();
            if (j < 1) {
                return 0;
            }
            Player player = (Player)level.m_6907_().get(random.m_188503_(j));
            if (player.m_5833_()) {
                return 0;
            }
            int k = (24 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1);
            int l = (24 + random.m_188503_(24)) * (random.m_188499_() ? -1 : 1);
            BlockPos.MutableBlockPos blockpos$mutableblockpos = player.m_20183_().m_122032_().m_122184_(k, 0, l);
            int i1 = 10;
            if (!level.m_151572_(blockpos$mutableblockpos.m_123341_() - 10, blockpos$mutableblockpos.m_123343_() - 10, blockpos$mutableblockpos.m_123341_() + 10, blockpos$mutableblockpos.m_123343_() + 10)) {
                return 0;
            }
            Holder holder = level.m_204166_((BlockPos)blockpos$mutableblockpos);
            if (holder.m_203656_(BiomeTags.f_215806_)) {
                return 0;
            }
            int j1 = 0;
            int k1 = (Integer)GraveyardConfig.COMMON.mobSpawnAttempts.get();
            boolean illagerSpawn = random.m_188499_();
            for (int l1 = 0; l1 < k1; ++l1) {
                ++j1;
                blockpos$mutableblockpos.m_142448_(level.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, (BlockPos)blockpos$mutableblockpos).m_123342_());
                if (l1 == 0) {
                    if (!this.spawnHordeEntity(level, (BlockPos)blockpos$mutableblockpos, random, true, illagerSpawn)) {
                        break;
                    }
                } else {
                    this.spawnHordeEntity(level, (BlockPos)blockpos$mutableblockpos, random, false, illagerSpawn);
                }
                blockpos$mutableblockpos.m_142451_(blockpos$mutableblockpos.m_123341_() + random.m_188503_(5) - random.m_188503_(5));
                blockpos$mutableblockpos.m_142443_(blockpos$mutableblockpos.m_123343_() + random.m_188503_(5) - random.m_188503_(5));
            }
            return j1;
        }
        return 0;
    }

    private boolean spawnHordeEntity(Level p_64565_, BlockPos p_64566_, RandomSource p_64567_, boolean p_64568_, boolean illagerSpawn) {
        HordeGraveyardEntity hordeEntity;
        BlockState blockstate = p_64565_.m_8055_(p_64566_);
        BlockState downState = p_64565_.m_8055_(p_64566_.m_7495_());
        if (!NaturalSpawner.m_47056_((BlockGetter)p_64565_, (BlockPos)p_64566_, (BlockState)blockstate, (FluidState)blockstate.m_60819_(), (EntityType)((EntityType)TGEntities.GHOUL.get()))) {
            return false;
        }
        if (p_64565_.m_7146_(p_64566_) > 1) {
            return false;
        }
        if (blockstate.m_60819_().m_192917_((Fluid)Fluids.f_76193_) || downState.m_60819_().m_192917_((Fluid)Fluids.f_76193_)) {
            return false;
        }
        if (!HostileGraveyardEntity.m_219019_((EntityType)((EntityType)TGEntities.GHOUL.get()), (LevelAccessor)p_64565_, (MobSpawnType)MobSpawnType.PATROL, (BlockPos)p_64566_, (RandomSource)p_64567_)) {
            return false;
        }
        if (!illagerSpawn) {
            hordeEntity = p_64567_.m_188499_() ? (HordeGraveyardEntity)((EntityType)TGEntities.GHOUL.get()).m_20615_(p_64565_) : (HordeGraveyardEntity)((EntityType)TGEntities.REVENANT.get()).m_20615_(p_64565_);
        } else {
            int rand = p_64567_.m_188503_(5);
            switch (rand) {
                case 0: 
                case 1: {
                    hordeEntity = (HordeGraveyardEntity)((EntityType)TGEntities.CORRUPTED_PILLAGER.get()).m_20615_(p_64565_);
                    break;
                }
                case 2: 
                case 3: {
                    hordeEntity = (HordeGraveyardEntity)((EntityType)TGEntities.CORRUPTED_VINDICATOR.get()).m_20615_(p_64565_);
                    break;
                }
                default: {
                    hordeEntity = (HordeGraveyardEntity)((EntityType)TGEntities.ACOLYTE.get()).m_20615_(p_64565_);
                }
            }
        }
        if (hordeEntity != null) {
            if (p_64568_) {
                hordeEntity.setPatrolLeader(true);
                hordeEntity.findPatrolTarget();
            }
            hordeEntity.m_6034_(p_64566_.m_123341_(), p_64566_.m_123342_(), p_64566_.m_123343_());
            if (ForgeHooks.canEntitySpawn((Mob)hordeEntity, (LevelAccessor)p_64565_, (double)p_64566_.m_123341_(), (double)p_64566_.m_123342_(), (double)p_64566_.m_123343_(), null, (MobSpawnType)MobSpawnType.PATROL) == -1) {
                return false;
            }
            hordeEntity.m_6518_((ServerLevelAccessor)((ServerLevel)p_64565_), p_64565_.m_6436_(p_64566_), MobSpawnType.PATROL, null, null);
            ((ServerLevel)p_64565_).m_47205_((Entity)hordeEntity);
            return true;
        }
        return false;
    }
}

