/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.events;

import com.finallion.graveyard.entities.horde.GraveyardHordeSpawner;
import com.finallion.graveyard.util.TGFileWriterReader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.server.ServerStoppedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="graveyard")
public class TGServerEvents {
    private static Map<ResourceLocation, GraveyardHordeSpawner> spawners = new HashMap<ResourceLocation, GraveyardHordeSpawner>();

    @SubscribeEvent
    public static void onServerStart(ServerStartingEvent event) {
        MinecraftServer server = event.getServer();
        spawners.put(Level.f_46428_.m_135782_(), new GraveyardHordeSpawner(server));
    }

    @SubscribeEvent
    public static void onWorldLoad(LevelEvent.Load event) {
        MinecraftServer server = event.getLevel().m_7654_();
        if (server != null) {
            new TGFileWriterReader.Load().onWorldLoad(server);
        }
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload event) {
        MinecraftServer server = event.getLevel().m_7654_();
        if (server != null) {
            new TGFileWriterReader.Unload().onWorldUnload(server);
        }
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        spawners.clear();
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        if (event.side != LogicalSide.SERVER) {
            return;
        }
        GraveyardHordeSpawner spawner = spawners.get(event.level.m_46472_().m_135782_());
        if (spawner != null) {
            spawner.tick(event.level);
        }
    }
}

