/*
 * Decompiled with CFR 0.152.
 */
package com.finallion.graveyard.world.structures;

import com.finallion.graveyard.config.GraveyardConfig;
import com.finallion.graveyard.init.TGEntities;
import com.finallion.graveyard.init.TGStructureType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.pools.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;

public class TGJigsawStructure
extends Structure {
    public static final int MAX_SIZE = 128;
    public static final WeightedRandomList<MobSpawnSettings.SpawnerData> MONSTER_SPAWNS = WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData((EntityType)TGEntities.SKELETON_CREEPER.get(), 35, 1, 2), new MobSpawnSettings.SpawnerData((EntityType)TGEntities.GHOUL.get(), 50, 1, 3), new MobSpawnSettings.SpawnerData((EntityType)TGEntities.REVENANT.get(), 45, 1, 3)});
    public static final WeightedRandomList<MobSpawnSettings.SpawnerData> EMPTY = WeightedRandomList.m_146332_();
    public static final WeightedRandomList<MobSpawnSettings.SpawnerData> ILLAGER_SPAWNS = WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.f_20513_, 10, 1, 1), new MobSpawnSettings.SpawnerData(EntityType.f_20493_, 10, 1, 1)});
    public static final Codec<TGJigsawStructure> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Structure.StructureSettings.f_226688_.forGetter(feature -> feature.config), (App)StructureTemplatePool.f_210555_.fieldOf("start_pool").forGetter(config -> config.startPool), (App)ResourceLocation.f_135803_.optionalFieldOf("start_jigsaw_name").forGetter(config -> config.startJigsawName), (App)Codec.intRange((int)0, (int)7).fieldOf("size").forGetter(config -> config.size), (App)HeightProvider.f_161970_.fieldOf("start_height").forGetter(config -> config.startHeight), (App)Codec.BOOL.fieldOf("use_expansion_hack").forGetter(config -> config.useExpansionHack), (App)Heightmap.Types.f_64274_.optionalFieldOf("project_start_to_heightmap").forGetter(structure -> structure.projectStartToHeightmap), (App)Codec.intRange((int)1, (int)128).fieldOf("max_distance_from_center").forGetter(structure -> structure.maxDistanceFromCenter), (App)Codec.INT.fieldOf("terrain_check_size").forGetter(structure -> structure.terrainCheckSize), (App)Codec.INT.fieldOf("max_height_difference").forGetter(structure -> structure.maxHeightDifference), (App)Codec.STRING.fieldOf("structure_name").forGetter(config -> config.structureName)).apply((Applicative)instance, TGJigsawStructure::new));
    public final Holder<StructureTemplatePool> startPool;
    public final Optional<ResourceLocation> startJigsawName;
    public final int size;
    public final HeightProvider startHeight;
    public final boolean useExpansionHack;
    public final Optional<Heightmap.Types> projectStartToHeightmap;
    public final int maxDistanceFromCenter;
    public final int terrainCheckSize;
    public final int maxHeightDifference;
    public final String structureName;
    protected final Structure.StructureSettings config;

    public TGJigsawStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, Optional<ResourceLocation> startJigsawName, int size, HeightProvider startHeight, Boolean useExpansionHack, Optional<Heightmap.Types> projectStartToHeightmap, int maxDistanceFromCenter, int terrainCheckSize, int maxHeightDifference, String structureName) {
        super(config);
        this.config = config;
        this.startPool = startPool;
        this.startJigsawName = startJigsawName;
        this.size = size;
        this.startHeight = startHeight;
        this.useExpansionHack = useExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
        this.maxDistanceFromCenter = maxDistanceFromCenter;
        this.maxHeightDifference = maxHeightDifference;
        this.terrainCheckSize = terrainCheckSize;
        this.structureName = structureName;
    }

    public TGJigsawStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, HeightProvider startHeight, boolean useExpansionHack, Heightmap.Types projectStartToHeightmap, int terrainCheckSize, int maxHeightDifference, String structureName) {
        this(config, startPool, Optional.empty(), size, startHeight, useExpansionHack, Optional.of(projectStartToHeightmap), 80, terrainCheckSize, maxHeightDifference, structureName);
    }

    public TGJigsawStructure(Structure.StructureSettings config, Holder<StructureTemplatePool> startPool, int size, HeightProvider startHeight, boolean useExpansionHack, int terrainCheckSize, int maxHeightDifference, String structureName) {
        this(config, startPool, Optional.empty(), size, startHeight, useExpansionHack, Optional.empty(), 80, terrainCheckSize, maxHeightDifference, structureName);
    }

    public Optional<Structure.GenerationStub> m_214086_(Structure.GenerationContext context) {
        if (!this.canGenerate(this.structureName)) {
            return Optional.empty();
        }
        BlockPos blockpos = context.f_226628_().m_151394_(0);
        if (this.structureName.equals("crypt")) {
            int minHeight = -40;
            int maxHeight = -10;
            ChunkPos chunkPos = context.f_226628_();
            WorldgenRandom random = context.f_226626_();
            int x = random.m_188503_(chunkPos.m_45608_() - chunkPos.m_45604_()) + chunkPos.m_45604_();
            int z = random.m_188503_(chunkPos.m_45609_() - chunkPos.m_151393_()) + chunkPos.m_151393_();
            int y = random.m_188503_(maxHeight - minHeight) + minHeight;
            blockpos = new BlockPos(x, y, z);
        } else if (this.structureName.equals("lich_prison")) {
            ChunkPos chunkPos = context.f_226628_();
            WorldgenRandom random = context.f_226626_();
            int x = random.m_188503_(chunkPos.m_45608_() - chunkPos.m_45604_()) + chunkPos.m_45604_();
            int z = random.m_188503_(chunkPos.m_45609_() - chunkPos.m_151393_()) + chunkPos.m_151393_();
            int y = 210;
            blockpos = new BlockPos(x, y, z);
        } else if (!TGJigsawStructure.canGenerate(context, this.terrainCheckSize, blockpos, this.maxHeightDifference)) {
            return Optional.empty();
        }
        return JigsawPlacement.m_227238_((Structure.GenerationContext)context, this.startPool, this.startJigsawName, (int)this.size, (BlockPos)blockpos, (boolean)this.useExpansionHack, this.projectStartToHeightmap, (int)this.maxDistanceFromCenter);
    }

    private static boolean canGenerate(Structure.GenerationContext context, int size, BlockPos centerOfChunk, int maxHeightDifference) {
        return TGJigsawStructure.isTerrainFlat(context, centerOfChunk, size, maxHeightDifference);
    }

    protected static boolean isTerrainFlat(Structure.GenerationContext context, BlockPos centerChunk, int size, int maxHeightDifference) {
        ChunkGenerator generator = context.f_226622_();
        LevelHeightAccessor heightLimitView = context.f_226629_();
        int chunkX = centerChunk.m_123341_();
        int chunkZ = centerChunk.m_123343_();
        RandomState noiseConfig = context.f_226624_();
        int i1 = generator.m_223235_(chunkX, chunkZ, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, noiseConfig);
        int j1 = generator.m_223235_(chunkX, chunkZ + size, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, noiseConfig);
        int k1 = generator.m_223235_(chunkX + size, chunkZ, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, noiseConfig);
        int o1 = generator.m_223235_(chunkX, chunkZ - size, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, noiseConfig);
        int p1 = generator.m_223235_(chunkX - size, chunkZ, Heightmap.Types.WORLD_SURFACE_WG, heightLimitView, noiseConfig);
        NoiseColumn sample1 = generator.m_214184_(chunkX, chunkZ, heightLimitView, noiseConfig);
        NoiseColumn sample2 = generator.m_214184_(chunkX, chunkZ + size, heightLimitView, noiseConfig);
        NoiseColumn sample3 = generator.m_214184_(chunkX + size, chunkZ, heightLimitView, noiseConfig);
        NoiseColumn sample4 = generator.m_214184_(chunkX, chunkZ - size, heightLimitView, noiseConfig);
        NoiseColumn sample5 = generator.m_214184_(chunkX - size, chunkZ, heightLimitView, noiseConfig);
        if (sample1.m_183556_(i1).m_60819_().m_205070_(FluidTags.f_13131_) || sample2.m_183556_(j1).m_60819_().m_205070_(FluidTags.f_13131_) || sample3.m_183556_(k1).m_60819_().m_205070_(FluidTags.f_13131_) || sample4.m_183556_(o1).m_60819_().m_205070_(FluidTags.f_13131_) || sample5.m_183556_(p1).m_60819_().m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        int minSides = Math.min(Math.min(j1, p1), Math.min(o1, k1));
        int minHeight = Math.min(minSides, i1);
        int maxSides = Math.max(Math.max(j1, p1), Math.max(o1, k1));
        int maxHeight = Math.max(maxSides, i1);
        return Math.abs(maxHeight - minHeight) <= maxHeightDifference;
    }

    public StructureType<?> m_213658_() {
        return TGStructureType.TG_JIGSAW;
    }

    private boolean canGenerate(String name) {
        return switch (name) {
            case "haunted_house" -> (Boolean)GraveyardConfig.COMMON.canGenerateHauntedHouse.get();
            case "large_graveyard" -> (Boolean)GraveyardConfig.COMMON.canGenerateLargeGraveyard.get();
            case "medium_graveyard" -> (Boolean)GraveyardConfig.COMMON.canGenerateMediumGraveyard.get();
            case "small_graveyard" -> (Boolean)GraveyardConfig.COMMON.canGenerateSmallGraveyard.get();
            case "small_desert_graveyard" -> (Boolean)GraveyardConfig.COMMON.canGenerateSmallDesertGraveyard.get();
            case "small_grave" -> (Boolean)GraveyardConfig.COMMON.canGenerateSmallGrave.get();
            case "small_mountain_grave" -> (Boolean)GraveyardConfig.COMMON.canGenerateSmallMountainGrave.get();
            case "small_savanna_grave" -> (Boolean)GraveyardConfig.COMMON.canGenerateSmallSavannaGrave.get();
            case "small_desert_grave" -> (Boolean)GraveyardConfig.COMMON.canGenerateSmallDesertGrave.get();
            case "mushroom_grave" -> (Boolean)GraveyardConfig.COMMON.canGenerateMushroomGrave.get();
            case "memorial_tree" -> (Boolean)GraveyardConfig.COMMON.canGenerateMemorialTree.get();
            case "crypt" -> (Boolean)GraveyardConfig.COMMON.canGenerateCrypt.get();
            case "altar" -> (Boolean)GraveyardConfig.COMMON.canGenerateAltar.get();
            case "giant_mushroom" -> (Boolean)GraveyardConfig.COMMON.canGenerateGiantMushroom.get();
            case "ruins" -> (Boolean)GraveyardConfig.COMMON.canGenerateRuins.get();
            case "lich_prison" -> (Boolean)GraveyardConfig.COMMON.canGenerateLichPrison.get();
            default -> false;
        };
    }
}

