/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.biome;

import com.epherical.croptopia.CroptopiaForge;
import com.epherical.croptopia.config.Config;
import com.epherical.croptopia.registry.GeneratorRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public record SaltModifier(GenerationStep.Decoration step, Holder<PlacedFeature> features) implements BiomeModifier
{
    public static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)CroptopiaForge.createIdentifier("salt"), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"croptopia");

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD && !Config.isSaltDisabled && !biome.m_203656_(Tags.Biomes.IS_SWAMP)) {
            BiomeGenerationSettingsBuilder generation = builder.getGenerationSettings();
            generation.m_255419_(this.step, this.features);
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)SERIALIZER.get();
    }

    public static Codec<SaltModifier> makeCodec() {
        return RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.comapFlatMap(SaltModifier::generationStageFromString, GenerationStep.Decoration::m_224194_).fieldOf("generation_stage").forGetter(SaltModifier::step), (App)PlacedFeature.f_191773_.fieldOf("feature").forGetter(SaltModifier::features)).apply((Applicative)builder, SaltModifier::new));
    }

    private static DataResult<GenerationStep.Decoration> generationStageFromString(String name) {
        try {
            return DataResult.success((Object)GenerationStep.Decoration.valueOf((String)name.toUpperCase(Locale.ROOT)));
        }
        catch (Exception e) {
            return DataResult.error((String)("Not a decoration stage: " + name));
        }
    }

    public static void register(DeferredRegister<BiomeModifier> biomeSerializer) {
        biomeSerializer.register("salt_disk", () -> new SaltModifier(GenerationStep.Decoration.UNDERGROUND_ORES, GeneratorRegistry.DISK_SALT_CONFIGURED));
    }
}

