/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.biome;

import com.epherical.croptopia.CroptopiaForge;
import com.epherical.croptopia.registry.GeneratorRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Locale;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.common.world.BiomeGenerationSettingsBuilder;
import net.minecraftforge.common.world.BiomeModifier;
import net.minecraftforge.common.world.ModifiableBiomeInfo;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;

public record TreeModifier(GenerationStep.Decoration step) implements BiomeModifier
{
    public static final RegistryObject<Codec<? extends BiomeModifier>> SERIALIZER = RegistryObject.create((ResourceLocation)CroptopiaForge.createIdentifier("trees"), (ResourceKey)ForgeRegistries.Keys.BIOME_MODIFIER_SERIALIZERS, (String)"croptopia");

    public void modify(Holder<Biome> biome, BiomeModifier.Phase phase, ModifiableBiomeInfo.BiomeInfo.Builder builder) {
        if (phase == BiomeModifier.Phase.ADD) {
            biome.m_203543_().ifPresent(biomeResourceKey -> {
                BiomeGenerationSettingsBuilder generation = builder.getGenerationSettings();
                Collection strings = CroptopiaForge.config.getFeatures().get((Object)biomeResourceKey.m_135782_());
                for (String string : strings) {
                    generation.m_255419_(this.step, GeneratorRegistry.getPlacedFeature(GeneratorRegistry.getFeatureKey(string)));
                }
            });
        }
    }

    public Codec<? extends BiomeModifier> codec() {
        return (Codec)SERIALIZER.get();
    }

    public static Codec<TreeModifier> makeCodec() {
        return RecordCodecBuilder.create(builder -> builder.group((App)Codec.STRING.comapFlatMap(TreeModifier::generationStageFromString, GenerationStep.Decoration::m_224194_).fieldOf("generation_stage").forGetter(TreeModifier::step)).apply((Applicative)builder, TreeModifier::new));
    }

    private static DataResult<GenerationStep.Decoration> generationStageFromString(String name) {
        try {
            return DataResult.success((Object)GenerationStep.Decoration.valueOf((String)name.toUpperCase(Locale.ROOT)));
        }
        catch (Exception e) {
            return DataResult.error((String)("Not a decoration stage: " + name));
        }
    }

    public static void register(DeferredRegister<BiomeModifier> biomeSerializer) {
        TreeModifier modifier = new TreeModifier(GenerationStep.Decoration.VEGETAL_DECORATION);
        biomeSerializer.register("tree_modifiers", () -> modifier);
    }
}

