/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.api.model;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import xfacthd.framedblocks.api.FramedBlocksAPI;
import xfacthd.framedblocks.api.FramedBlocksClientAPI;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.model.BakedModelProxy;
import xfacthd.framedblocks.api.model.data.FramedBlockData;
import xfacthd.framedblocks.api.model.data.QuadTable;
import xfacthd.framedblocks.api.model.util.ModelCache;
import xfacthd.framedblocks.api.model.util.ModelUtils;
import xfacthd.framedblocks.api.predicate.ConTexMode;
import xfacthd.framedblocks.api.predicate.CtmPredicate;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.Utils;

public abstract class FramedBlockModel
extends BakedModelProxy {
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final FramedBlockData DEFAULT_DATA = new FramedBlockData.Immutable(Blocks.f_50016_.m_49966_(), new boolean[6], false);
    public static final ResourceLocation REINFORCEMENT_LOCATION = Utils.rl("block/framed_reinforcement");
    private static BakedModel reinforcementModel = null;
    private final Cache<QuadCacheKey, QuadTable> quadCache = Caffeine.newBuilder().expireAfterAccess(ModelCache.DEFAULT_CACHE_DURATION).build();
    private final Cache<QuadCacheKey, CachedRenderTypes> renderTypeCache = Caffeine.newBuilder().expireAfterAccess(ModelCache.DEFAULT_CACHE_DURATION).build();
    protected final BlockState state;
    private final ChunkRenderTypeSet baseModelRenderTypes;
    private final boolean cacheFullRenderTypes;
    private final boolean forceUngeneratedBaseModel;
    private final boolean useBaseModel;
    private final boolean transformAllQuads;
    private final FullFaceCache fullFaceCache;

    public FramedBlockModel(BlockState state, BakedModel baseModel) {
        super(baseModel);
        this.state = state;
        this.baseModelRenderTypes = this.getBaseModelRenderTypes();
        this.cacheFullRenderTypes = this.canFullyCacheRenderTypes();
        this.forceUngeneratedBaseModel = this.forceUngeneratedBaseModel();
        this.useBaseModel = this.useBaseModel();
        this.transformAllQuads = this.transformAllQuads(state);
        IBlockType type = ((IFramedBlock)state.m_60734_()).getBlockType();
        this.fullFaceCache = new FullFaceCache(type, state);
        Preconditions.checkState((this.useBaseModel || !this.forceUngeneratedBaseModel ? 1 : 0) != 0, (Object)"FramedBlockModel::useBaseModel() must return true when FramedBlockModel::forceUngeneratedBaseModel() returns true");
    }

    public List<BakedQuad> getQuads(BlockState state, Direction side, RandomSource rand, ModelData extraData, RenderType renderType) {
        FramedBlockData data;
        BlockState camoState = Blocks.f_50016_.m_49966_();
        if (state == null) {
            state = this.state;
        }
        if ((data = (FramedBlockData)extraData.get(FramedBlockData.PROPERTY)) != null && renderType != null) {
            if (side != null && data.isSideHidden(side)) {
                return Collections.emptyList();
            }
            camoState = data.getCamoState();
            if (camoState != null && !camoState.m_60795_()) {
                return this.getCamoQuads(state, camoState, side, rand, extraData, data, renderType);
            }
        }
        if (data == null) {
            data = DEFAULT_DATA;
        }
        if (renderType == null) {
            renderType = RenderType.m_110463_();
        }
        if (camoState == null || camoState.m_60795_()) {
            return this.getCamoQuads(state, null, side, rand, extraData, data, renderType);
        }
        return Collections.emptyList();
    }

    @Override
    public List<BakedQuad> m_213637_(BlockState state, Direction side, RandomSource rand) {
        if (state == null) {
            state = this.state;
        }
        return this.getCamoQuads(state, null, side, rand, ModelData.EMPTY, DEFAULT_DATA, RenderType.m_110463_());
    }

    public ChunkRenderTypeSet getRenderTypes(@NotNull BlockState state, @NotNull RandomSource rand, @NotNull ModelData data) {
        BlockState camoState;
        FramedBlockData fbData = (FramedBlockData)data.get(FramedBlockData.PROPERTY);
        if (fbData == null) {
            fbData = DEFAULT_DATA;
        }
        BlockState keyState = camoState = fbData.getCamoState();
        if (camoState == null || camoState.m_60795_()) {
            camoState = Blocks.f_50016_.m_49966_();
            keyState = this.getNoCamoModelState(FramedBlocksAPI.getInstance().defaultModelState(), fbData);
        }
        CachedRenderTypes cachedTypes = this.getCachedRenderTypes(keyState, camoState, fbData, rand, data);
        if (this.cacheFullRenderTypes) {
            return cachedTypes.allTypes;
        }
        ChunkRenderTypeSet renderTypes = cachedTypes.camoTypes;
        ChunkRenderTypeSet overlayTypes = this.getAdditionalRenderTypes(rand, data);
        if (!overlayTypes.isEmpty()) {
            renderTypes = ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{renderTypes, overlayTypes});
        }
        return renderTypes;
    }

    private CachedRenderTypes getCachedRenderTypes(BlockState keyState, BlockState camoState, FramedBlockData fbData, RandomSource rand, ModelData data) {
        return (CachedRenderTypes)this.renderTypeCache.get((Object)this.makeCacheKey(keyState, null, data), key -> this.buildRenderTypeCache(camoState, fbData, rand, data));
    }

    private CachedRenderTypes buildRenderTypeCache(BlockState camoState, FramedBlockData fbData, RandomSource rand, ModelData data) {
        ChunkRenderTypeSet camoTypes = this.baseModelRenderTypes;
        if (!camoState.m_60795_()) {
            camoTypes = ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{ModelCache.getRenderTypes(camoState, rand, ModelData.EMPTY), ModelCache.getCamoRenderTypes(camoState, rand, data)});
        } else if (fbData.isReinforced()) {
            camoTypes = ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{this.baseModelRenderTypes, ModelUtils.CUTOUT});
        }
        return new CachedRenderTypes(camoTypes, this.cacheFullRenderTypes ? this.getAdditionalRenderTypes(rand, data) : ChunkRenderTypeSet.none());
    }

    private List<BakedQuad> getCamoQuads(BlockState state, BlockState camoState, Direction side, RandomSource rand, ModelData extraData, FramedBlockData fbData, RenderType renderType) {
        ModelData camoData;
        BakedModel model;
        boolean noProcessing;
        boolean camoInRenderType;
        boolean addReinforcement;
        boolean needCtCtx;
        boolean noCamo;
        boolean bl = noCamo = camoState == null;
        if (noCamo) {
            needCtCtx = false;
            camoState = this.getNoCamoModelState(FramedBlocksAPI.getInstance().defaultModelState(), fbData);
            addReinforcement = this.useBaseModel && fbData.isReinforced();
            camoInRenderType = this.baseModelRenderTypes.contains(renderType);
            noProcessing = camoInRenderType && this.forceUngeneratedBaseModel || this.fullFaceCache.isFullFace(side);
            model = this.getCamoModel(camoState, this.useBaseModel);
            camoData = ModelData.EMPTY;
        } else {
            noProcessing = this.fullFaceCache.isFullFace(side);
            needCtCtx = FramedBlockModel.needCtContext(noProcessing);
            model = this.getCamoModel(camoState, false);
            camoData = needCtCtx ? ModelUtils.getCamoModelData(extraData) : ModelData.EMPTY;
            camoInRenderType = this.getCachedRenderTypes((BlockState)camoState, (BlockState)camoState, (FramedBlockData)fbData, (RandomSource)rand, (ModelData)camoData).camoTypes.contains(renderType);
            addReinforcement = false;
        }
        if (noProcessing) {
            ChunkRenderTypeSet addLayers = this.getAdditionalRenderTypes(rand, extraData);
            boolean additionalQuads = addLayers.contains(renderType);
            if (!(camoInRenderType || additionalQuads || addReinforcement)) {
                return List.of();
            }
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            if (camoInRenderType) {
                quads.addAll(model.getQuads(camoState, side, rand, camoData, renderType));
            }
            if (additionalQuads) {
                this.getAdditionalQuads(quads, side, state, rand, extraData, renderType);
            }
            if (addReinforcement && renderType == RenderType.m_110463_()) {
                quads.addAll(reinforcementModel.getQuads(camoState, side, rand, camoData, renderType));
            }
            return quads;
        }
        Object ctCtx = needCtCtx ? FramedBlocksClientAPI.getInstance().extractCTContext(camoData) : null;
        return ((QuadTable)this.quadCache.get((Object)this.makeCacheKey(camoState, ctCtx, extraData), key -> this.buildQuadCache(state, key.state(), rand, extraData, ctCtx != null ? camoData : ModelData.EMPTY, noCamo, addReinforcement))).getQuads(renderType, side);
    }

    private static boolean needCtContext(boolean noProcessing) {
        ConTexMode mode = FramedBlocksClientAPI.getInstance().getConTexMode();
        if (mode == ConTexMode.NONE) {
            return false;
        }
        return noProcessing || mode.atleast(ConTexMode.FULL_CON_FACE);
    }

    private QuadTable buildQuadCache(BlockState state, BlockState camoState, RandomSource rand, ModelData data, ModelData camoData, boolean noCamo, boolean addReinforcement) {
        QuadTable quadTable = new QuadTable();
        ChunkRenderTypeSet camoLayers = noCamo ? (addReinforcement ? ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{this.baseModelRenderTypes, ModelUtils.CUTOUT}) : this.baseModelRenderTypes) : ModelCache.getRenderTypes(camoState, rand, camoData);
        for (RenderType renderType : this.getRenderTypes(state, rand, data)) {
            boolean camoInRenderType = camoLayers.contains(renderType);
            quadTable.put(renderType, this.makeQuads(state, camoState, rand, data, camoData, renderType, camoInRenderType, noCamo, addReinforcement && renderType == RenderType.m_110463_()));
        }
        return quadTable;
    }

    private Map<Direction, List<BakedQuad>> makeQuads(BlockState state, BlockState camoState, RandomSource rand, ModelData data, ModelData camoData, RenderType renderType, boolean camoInRenderType, boolean noCamo, boolean addReinforcement) {
        ChunkRenderTypeSet addLayers;
        IdentityHashMap<Direction, List<BakedQuad>> quadMap = new IdentityHashMap<Direction, List<BakedQuad>>();
        quadMap.put(null, new ArrayList());
        for (Direction dir : DIRECTIONS) {
            quadMap.put(dir, new ArrayList());
        }
        if (camoInRenderType) {
            BakedModel camoModel = this.getCamoModel(camoState, noCamo && this.useBaseModel);
            List<BakedQuad> quads = ModelUtils.getAllCullableQuads(camoModel, camoState, rand, camoData, renderType);
            if (addReinforcement) {
                quads.addAll(ModelUtils.getAllCullableQuads(reinforcementModel, camoState, rand, camoData, renderType));
            }
            if (!this.transformAllQuads) {
                quads.removeIf(q -> this.fullFaceCache.isFullFace(q.m_111306_()));
            }
            for (BakedQuad quad : quads) {
                this.transformQuad(quadMap, quad, data);
            }
            this.postProcessQuads(quadMap);
        }
        if ((addLayers = this.getAdditionalRenderTypes(rand, data)).contains(renderType)) {
            this.getAdditionalQuads(quadMap, state, rand, data, renderType);
        }
        return quadMap;
    }

    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad, ModelData data) {
        this.transformQuad(quadMap, quad);
    }

    protected abstract void transformQuad(Map<Direction, List<BakedQuad>> var1, BakedQuad var2);

    protected void postProcessQuads(Map<Direction, List<BakedQuad>> quadMap) {
    }

    protected boolean forceUngeneratedBaseModel() {
        return false;
    }

    protected boolean useBaseModel() {
        return this.forceUngeneratedBaseModel();
    }

    protected boolean transformAllQuads(BlockState state) {
        return false;
    }

    protected ChunkRenderTypeSet getBaseModelRenderTypes() {
        return ModelUtils.CUTOUT;
    }

    protected boolean canFullyCacheRenderTypes() {
        return true;
    }

    @ApiStatus.Internal
    protected BlockState getNoCamoModelState(BlockState camoState, FramedBlockData fbData) {
        if (fbData.useAltModel()) {
            camoState = (BlockState)camoState.m_61124_((Property)FramedProperties.ALT, (Comparable)Boolean.valueOf(true));
        }
        if (fbData.isReinforced()) {
            camoState = (BlockState)camoState.m_61124_((Property)FramedProperties.REINFORCED, (Comparable)Boolean.valueOf(true));
        }
        return camoState;
    }

    protected BakedModel getCamoModel(BlockState camoState, boolean useBaseModel) {
        if (useBaseModel) {
            return this.baseModel;
        }
        return ModelCache.getModel(camoState);
    }

    protected ChunkRenderTypeSet getAdditionalRenderTypes(RandomSource rand, ModelData extraData) {
        return ChunkRenderTypeSet.none();
    }

    protected void getAdditionalQuads(List<BakedQuad> quads, Direction side, BlockState state, RandomSource rand, ModelData data, RenderType renderType) {
    }

    protected void getAdditionalQuads(Map<Direction, List<BakedQuad>> quadMap, BlockState state, RandomSource rand, ModelData data, RenderType renderType) {
    }

    protected QuadCacheKey makeCacheKey(BlockState state, Object ctCtx, ModelData data) {
        return new SimpleQuadCacheKey(state, ctCtx);
    }

    @Nonnull
    public final ModelData getModelData(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull ModelData tileData) {
        FramedBlockData data = (FramedBlockData)tileData.get(FramedBlockData.PROPERTY);
        if (data != null && !data.getCamoState().m_60795_()) {
            BlockState camoState = data.getCamoState();
            BakedModel model = ModelCache.getModel(camoState);
            tileData = tileData.derive().with(FramedBlockData.CAMO_DATA, (Object)model.getModelData(level, pos, camoState, tileData)).build();
        }
        return tileData;
    }

    public TextureAtlasSprite getParticleIcon(ModelData data) {
        BlockState camoState;
        FramedBlockData fbdata = (FramedBlockData)data.get(FramedBlockData.PROPERTY);
        if (fbdata != null && !(camoState = fbdata.getCamoState()).m_60795_()) {
            return this.getCamoModel(camoState, false).m_6160_();
        }
        return this.baseModel.m_6160_();
    }

    public final void clearCache() {
        this.quadCache.invalidateAll();
        this.renderTypeCache.invalidateAll();
    }

    public static void captureReinforcementModel(Map<ResourceLocation, BakedModel> models) {
        reinforcementModel = models.get(REINFORCEMENT_LOCATION);
    }

    private static class FullFaceCache {
        private final boolean[] cache = new boolean[7];

        public FullFaceCache(IBlockType type, BlockState state) {
            CtmPredicate pred = type.getCtmPredicate();
            for (Direction side : DIRECTIONS) {
                boolean full;
                this.cache[side.ordinal()] = full = pred.test(state, side);
            }
            this.cache[6] = false;
        }

        public boolean isFullFace(Direction side) {
            return side != null && this.cache[side.ordinal()];
        }
    }

    private record CachedRenderTypes(ChunkRenderTypeSet camoTypes, ChunkRenderTypeSet overlayTypes, ChunkRenderTypeSet allTypes) {
        public CachedRenderTypes(ChunkRenderTypeSet camoTypes, ChunkRenderTypeSet overlayTypes) {
            this(camoTypes, overlayTypes, ChunkRenderTypeSet.union((ChunkRenderTypeSet[])new ChunkRenderTypeSet[]{camoTypes, overlayTypes}));
        }
    }

    protected static interface QuadCacheKey {
        public BlockState state();

        public Object ctCtx();
    }

    private record SimpleQuadCacheKey(BlockState state, Object ctCtx) implements QuadCacheKey
    {
    }
}

