/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.model.prism;

import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.model.FramedBlockModel;
import xfacthd.framedblocks.api.model.quad.Modifiers;
import xfacthd.framedblocks.api.model.quad.QuadModifier;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.DirectionAxis;

public class FramedInnerPrismModel
extends FramedBlockModel {
    private final Direction facing;
    private final Direction.Axis axis;
    private final boolean ySlope;

    public FramedInnerPrismModel(BlockState state, BakedModel baseModel) {
        super(state, baseModel);
        DirectionAxis dirAxis = (DirectionAxis)((Object)state.m_61143_(PropertyHolder.FACING_AXIS));
        this.facing = dirAxis.direction();
        this.axis = dirAxis.axis();
        this.ySlope = (Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE);
    }

    @Override
    protected void transformQuad(Map<Direction, List<BakedQuad>> quadMap, BakedQuad quad) {
        boolean quadOnAxis;
        boolean yFacing = Utils.isY(this.facing);
        boolean yAxis = this.axis == Direction.Axis.Y;
        Direction quadFace = quad.m_111306_();
        boolean quadOnFacingAxis = quadFace.m_122434_() == this.facing.m_122434_();
        boolean bl = quadOnAxis = quadFace.m_122434_() == this.axis;
        if (!this.ySlope && yFacing && !quadOnAxis && !quadOnFacingAxis) {
            boolean up = this.facing == Direction.UP;
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(up, 0.5f)).apply(Modifiers.makeVerticalSlope(up, 45.0f)).export(quadMap.get(null));
        } else if (this.ySlope && yFacing && quadFace == this.facing) {
            Direction onAxis = Direction.m_122387_((Direction.Axis)this.axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            Direction offAxisCW = onAxis.m_122427_();
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(offAxisCW, 0.5f)).apply(Modifiers.makeVerticalSlope(offAxisCW, 45.0f)).export(quadMap.get(null));
            Direction offAxisCCW = onAxis.m_122428_();
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(offAxisCCW, 0.5f)).apply(Modifiers.makeVerticalSlope(offAxisCCW, 45.0f)).export(quadMap.get(null));
        } else if (!yFacing && yAxis && !quadOnAxis && !quadOnFacingAxis) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(this.facing.m_122424_(), 0.5f)).apply(Modifiers.makeHorizontalSlope(quadFace == this.facing.m_122428_(), 45.0f)).export(quadMap.get(null));
        } else if (!(this.ySlope || yFacing || yAxis || quadFace != this.facing)) {
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.makeVerticalSlope(true, 45.0f)).export(quadMap.get(null));
            QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.makeVerticalSlope(false, 45.0f)).export(quadMap.get(null));
        } else if (this.ySlope && !yFacing && !yAxis && Utils.isY(quadFace)) {
            QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122424_(), 0.5f)).apply(Modifiers.makeVerticalSlope(this.facing, 45.0f)).export(quadMap.get(null));
        } else if (quadOnAxis) {
            if (yAxis) {
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122427_(), 0.5f)).apply(Modifiers.cutTopBottom(this.facing, 0.0f, 1.0f)).export(quadMap.get(quadFace));
                QuadModifier.geometry(quad).apply(Modifiers.cutTopBottom(this.facing.m_122428_(), 0.5f)).apply(Modifiers.cutTopBottom(this.facing, 1.0f, 0.0f)).export(quadMap.get(quadFace));
            } else if (yFacing) {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(quadFace.m_122427_(), 0.5f)).apply(Modifiers.cutSideUpDown(this.facing == Direction.DOWN, 0.0f, 1.0f)).export(quadMap.get(quadFace));
                QuadModifier.geometry(quad).apply(Modifiers.cutSideLeftRight(quadFace.m_122428_(), 0.5f)).apply(Modifiers.cutSideUpDown(this.facing == Direction.DOWN, 1.0f, 0.0f)).export(quadMap.get(quadFace));
            } else {
                QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(true, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing, 1.0f, 0.0f)).export(quadMap.get(quadFace));
                QuadModifier.geometry(quad).apply(Modifiers.cutSideUpDown(false, 0.5f)).apply(Modifiers.cutSideLeftRight(this.facing, 0.0f, 1.0f)).export(quadMap.get(quadFace));
            }
        }
    }

    @Override
    protected boolean transformAllQuads(BlockState state) {
        if (((Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE)).booleanValue()) {
            return true;
        }
        DirectionAxis dirAxis = (DirectionAxis)((Object)state.m_61143_(PropertyHolder.FACING_AXIS));
        return Utils.isY(dirAxis.direction()) || dirAxis.axis() == Direction.Axis.Y;
    }

    public static BlockState itemSource() {
        return (BlockState)((Block)FBContent.blockFramedInnerPrism.get()).m_49966_().m_61124_(PropertyHolder.FACING_AXIS, (Comparable)((Object)DirectionAxis.UP_X));
    }
}

