/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.phys.Vec3;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.blockentity.FramedItemFrameBlockEntity;

public class FramedItemFrameRenderer
implements BlockEntityRenderer<FramedItemFrameBlockEntity> {
    private static final double ITEM_Z_OFF = 0.4375;
    private static final float DIR_OFF_MULT = 0.49875f;
    private static final float MAP_SCALE = 0.0078125f;
    private final ItemRenderer itemRenderer;

    public FramedItemFrameRenderer(BlockEntityRendererProvider.Context ctx) {
        this.itemRenderer = ctx.m_234447_();
    }

    public void render(FramedItemFrameBlockEntity be, float partialTick, PoseStack pstack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        float yRot;
        pstack.m_85836_();
        Direction dir = ((Direction)be.m_58900_().m_61143_((Property)BlockStateProperties.f_61372_)).m_122424_();
        float dirOff = Utils.isPositive(dir) ? 0.0f : 1.0f;
        pstack.m_252880_((float)dir.m_122429_() * 0.49875f + (Utils.isX(dir) ? dirOff : 0.5f), (float)dir.m_122430_() * 0.49875f + (Utils.isY(dir) ? dirOff : 0.5f), (float)dir.m_122431_() * 0.49875f + (Utils.isZ(dir) ? dirOff : 0.5f));
        boolean vert = Utils.isY(dir);
        float f = yRot = vert ? 0.0f : dir.m_122435_();
        if (vert) {
            pstack.m_252781_(Axis.f_252529_.m_252977_(-90.0f * (float)dir.m_122421_().m_122540_()));
        }
        pstack.m_252781_(Axis.f_252436_.m_252977_(180.0f - yRot));
        ItemStack item = be.getItem();
        MapItemSavedData mapData = MapItem.m_42853_((ItemStack)item, (Level)be.m_58904_());
        pstack.m_85837_(0.0, 0.0, 0.4375);
        float itemRotation = mapData != null ? (float)(be.getRotation() % 4 * 2) : (float)be.getRotation();
        pstack.m_252781_(Axis.f_252403_.m_252977_(itemRotation * 360.0f / 8.0f));
        if (mapData != null) {
            pstack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
            pstack.m_85841_(0.0078125f, 0.0078125f, 0.0078125f);
            pstack.m_85837_(-64.0, -64.0, -1.0);
            int mapLight = be.isGlowingFrame() ? 15728850 : packedLight;
            int mapId = MapItem.m_151131_((ItemStack)item);
            Minecraft.m_91087_().f_91063_.m_109151_().m_168771_(pstack, buffer, mapId, mapData, true, mapLight);
        } else {
            pstack.m_85841_(0.5f, 0.5f, 0.5f);
            int itemLight = be.isGlowingFrame() ? 0xF000F0 : packedLight;
            this.itemRenderer.m_174269_(item, ItemTransforms.TransformType.FIXED, itemLight, OverlayTexture.f_118083_, pstack, buffer, 0);
        }
        pstack.m_85849_();
    }

    public boolean shouldRender(FramedItemFrameBlockEntity be, Vec3 cameraPos) {
        return be.hasItem() && super.m_142756_((BlockEntity)be, cameraPos);
    }
}

