/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.cube;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TargetBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.extensions.common.IClientBlockExtensions;
import net.minecraftforge.common.IPlantable;
import xfacthd.framedblocks.api.block.FramedBlockRenderProperties;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.common.blockentity.FramedTargetBlockEntity;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedTargetBlock
extends TargetBlock
implements IFramedBlock {
    public FramedTargetBlock() {
        super(IFramedBlock.createProperties(BlockType.FRAMED_TARGET));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.GLOWING, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.SOLID, FramedProperties.GLOWING});
    }

    public final InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockEntity;
        InteractionResult result = this.handleUse(state, level, pos, player, hand, hit);
        if (result != InteractionResult.PASS || !player.m_36326_()) {
            return result;
        }
        ItemStack stack = player.m_21120_(hand);
        if (!stack.m_41619_() && (blockEntity = level.m_7702_(pos)) instanceof FramedTargetBlockEntity) {
            FramedTargetBlockEntity be = (FramedTargetBlockEntity)blockEntity;
            DyeColor dye = DyeColor.getColor((ItemStack)stack);
            if (dye != null && be.setOverlayColor(dye)) {
                level.m_5594_(player, pos, SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 1.0f);
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        this.tryApplyCamoImmediately(level, pos, placer, stack);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        this.updateCulling(level, currentPos, neighborState, direction, false);
        return super.m_7417_(state, direction, neighborState, level, currentPos, neighborPos);
    }

    public boolean m_7923_(BlockState state) {
        return this.useCamoOcclusionShapeForLightOcclusion(state);
    }

    public VoxelShape m_7952_(BlockState state, BlockGetter level, BlockPos pos) {
        return this.getCamoOcclusionShape(state, level, pos);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return this.getCamoVisualShape(state, level, pos, ctx);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        if (this.isIntangible(state, level, pos, ctx)) {
            return Shapes.m_83040_();
        }
        return super.m_5940_(state, level, pos, ctx);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        return this.getCamoDrops(super.m_7381_(state, builder), builder);
    }

    public boolean canSustainPlant(BlockState state, BlockGetter level, BlockPos pos, Direction side, IPlantable plant) {
        return this.canCamoSustainPlant(state, level, pos, side, plant);
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new FramedTargetBlockEntity(pos, state);
    }

    public void initializeClient(Consumer<IClientBlockExtensions> consumer) {
        consumer.accept(new FramedBlockRenderProperties());
    }

    @Override
    public IBlockType getBlockType() {
        return BlockType.FRAMED_TARGET;
    }
}

