/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.door;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.door.FramedDoorBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedGateBlock
extends FramedBlock {
    private static final VoxelShape SHAPE_SOUTH = FramedGateBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    private static final VoxelShape SHAPE_NORTH = FramedGateBlock.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_WEST = FramedGateBlock.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_EAST = FramedGateBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private final SoundEvent closeSound;
    private final SoundEvent openSound;

    private FramedGateBlock(BlockType blockType, BlockBehaviour.Properties props, SoundEvent closeSound, SoundEvent openSound) {
        super(blockType, props);
        this.closeSound = closeSound;
        this.openSound = openSound;
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.SOLID, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_, BlockStateProperties.f_61394_, BlockStateProperties.f_61446_, BlockStateProperties.f_61448_, FramedProperties.SOLID});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        boolean powered = level.m_46753_(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_())).m_61124_((Property)BlockStateProperties.f_61394_, (Comparable)this.getHinge(context))).m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(powered))).m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(powered));
    }

    private DoorHingeSide getHinge(BlockPlaceContext context) {
        double xz;
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Direction dir = context.m_8125_();
        BlockPos posLeft = pos.m_121945_(dir.m_122428_());
        BlockState stateLeft = level.m_8055_(posLeft);
        BlockPos posRight = pos.m_121945_(dir.m_122427_());
        BlockState stateRight = level.m_8055_(posRight);
        if (stateLeft.m_60713_((Block)this) || stateRight.m_60838_((BlockGetter)level, posRight)) {
            return DoorHingeSide.RIGHT;
        }
        if (stateRight.m_60713_((Block)this) || stateLeft.m_60838_((BlockGetter)level, posLeft)) {
            return DoorHingeSide.LEFT;
        }
        Vec3 hitVec = Utils.fraction(context.m_43720_());
        double d = xz = Utils.isX(dir) ? hitVec.m_7094_() : hitVec.m_7096_();
        if (Utils.isPositive(dir.m_122428_())) {
            xz = 1.0 - xz;
        }
        return xz > 0.5 ? DoorHingeSide.RIGHT : DoorHingeSide.LEFT;
    }

    @Override
    public final InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = super.m_6227_(state, level, pos, player, hand, hit);
        if (result.m_19077_()) {
            return result;
        }
        if (this.f_60442_ == FramedDoorBlock.IRON_WOOD) {
            return InteractionResult.PASS;
        }
        state = (BlockState)state.m_61122_((Property)BlockStateProperties.f_61446_);
        level.m_46597_(pos, state);
        boolean open = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_);
        this.playSound((Entity)player, level, pos, open);
        level.m_142346_((Entity)player, open ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
        return InteractionResult.m_19078_((boolean)level.m_5776_());
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean powered = level.m_46753_(pos);
        if (!this.m_49966_().m_60713_(block) && powered != (Boolean)state.m_61143_((Property)BlockStateProperties.f_61448_)) {
            if (powered != (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_)) {
                this.playSound(null, level, pos, powered);
                level.m_142346_(null, powered ? GameEvent.f_157796_ : GameEvent.f_157793_, pos);
            }
            level.m_7731_(pos, (BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61448_, (Comparable)Boolean.valueOf(powered))).m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(powered)), 2);
        }
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        boolean open = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_) == false;
        boolean rightHinge = state.m_61143_((Property)BlockStateProperties.f_61394_) == DoorHingeSide.RIGHT;
        return switch ((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)) {
            case Direction.NORTH -> {
                if (open) {
                    yield SHAPE_NORTH;
                }
                if (rightHinge) {
                    yield SHAPE_WEST;
                }
                yield SHAPE_EAST;
            }
            case Direction.EAST -> {
                if (open) {
                    yield SHAPE_EAST;
                }
                if (rightHinge) {
                    yield SHAPE_NORTH;
                }
                yield SHAPE_SOUTH;
            }
            case Direction.SOUTH -> {
                if (open) {
                    yield SHAPE_SOUTH;
                }
                if (rightHinge) {
                    yield SHAPE_EAST;
                }
                yield SHAPE_WEST;
            }
            case Direction.WEST -> {
                if (open) {
                    yield SHAPE_WEST;
                }
                if (rightHinge) {
                    yield SHAPE_SOUTH;
                }
                yield SHAPE_NORTH;
            }
            default -> SHAPE_NORTH;
        };
    }

    @Override
    public boolean doesBlockOccludeBeaconBeam(BlockState state, LevelReader level, BlockPos pos) {
        return false;
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        if (mirror == Mirror.NONE) {
            return state;
        }
        return (BlockState)state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)BlockStateProperties.f_61374_))).m_61122_((Property)BlockStateProperties.f_61394_);
    }

    @Override
    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return switch (type) {
            case PathComputationType.LAND, PathComputationType.AIR -> (Boolean)state.m_61143_((Property)BlockStateProperties.f_61446_);
            default -> false;
        };
    }

    private void playSound(@Nullable Entity entity, Level level, BlockPos pos, boolean open) {
        level.m_245803_(entity, pos, open ? this.openSound : this.closeSound, SoundSource.BLOCKS, 1.0f, level.m_213780_().m_188501_() * 0.1f + 0.9f);
    }

    public static FramedGateBlock wood() {
        return new FramedGateBlock(BlockType.FRAMED_GATE, IFramedBlock.createProperties(BlockType.FRAMED_GATE), SoundEvents.f_12626_, SoundEvents.f_12627_);
    }

    public static FramedGateBlock iron() {
        return new FramedGateBlock(BlockType.FRAMED_IRON_GATE, IFramedBlock.createProperties(BlockType.FRAMED_IRON_GATE, FramedDoorBlock.IRON_WOOD).m_60999_(), SoundEvents.f_12055_, SoundEvents.f_12056_);
    }
}

