/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.pillar;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedLatticeBlock
extends FramedBlock {
    public FramedLatticeBlock() {
        super(BlockType.FRAMED_LATTICE_BLOCK);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.X_AXIS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Y_AXIS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.Z_AXIS, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FramedProperties.STATE_LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.X_AXIS, FramedProperties.Y_AXIS, FramedProperties.Z_AXIS, BlockStateProperties.f_61362_, FramedProperties.STATE_LOCKED});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level level = context.m_43725_();
        BlockPos pos = context.m_8083_();
        BlockState state = this.m_49966_();
        state = (BlockState)state.m_61124_((Property)FramedProperties.X_AXIS, (Comparable)Boolean.valueOf(level.m_8055_(pos.m_122029_()).m_60713_((Block)this) || level.m_8055_(pos.m_122024_()).m_60713_((Block)this)));
        state = (BlockState)state.m_61124_((Property)FramedProperties.Y_AXIS, (Comparable)Boolean.valueOf(level.m_8055_(pos.m_7494_()).m_60713_((Block)this) || level.m_8055_(pos.m_7495_()).m_60713_((Block)this)));
        state = (BlockState)state.m_61124_((Property)FramedProperties.Z_AXIS, (Comparable)Boolean.valueOf(level.m_8055_(pos.m_122012_()).m_60713_((Block)this) || level.m_8055_(pos.m_122019_()).m_60713_((Block)this)));
        return FramedLatticeBlock.withWater(state, (LevelReader)level, pos);
    }

    @Override
    public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos pos, BlockPos facingPos) {
        if (!((Boolean)state.m_61143_((Property)FramedProperties.STATE_LOCKED)).booleanValue()) {
            state = (BlockState)state.m_61124_((Property)FramedLatticeBlock.getPropFromAxis(facing), (Comparable)Boolean.valueOf(facingState.m_60713_((Block)this) || level.m_8055_(pos.m_121945_(facing.m_122424_())).m_60713_((Block)this)));
        }
        return super.m_7417_(state, facing, facingState, level, pos, facingPos);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        if (rot != Rotation.NONE && rot != Rotation.CLOCKWISE_180) {
            boolean xAxis = (Boolean)state.m_61143_((Property)FramedProperties.Z_AXIS);
            boolean zAxis = (Boolean)state.m_61143_((Property)FramedProperties.X_AXIS);
            return (BlockState)((BlockState)state.m_61124_((Property)FramedProperties.X_AXIS, (Comparable)Boolean.valueOf(xAxis))).m_61124_((Property)FramedProperties.Z_AXIS, (Comparable)Boolean.valueOf(zAxis));
        }
        return state;
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape xShape = FramedLatticeBlock.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
        VoxelShape yShape = FramedLatticeBlock.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape zShape = FramedLatticeBlock.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)16.0);
        for (BlockState state : states) {
            VoxelShape shape = FramedLatticeBlock.m_49796_((double)6.0, (double)6.0, (double)6.0, (double)10.0, (double)10.0, (double)10.0);
            if (((Boolean)state.m_61143_((Property)FramedProperties.X_AXIS)).booleanValue()) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)xShape);
            }
            if (((Boolean)state.m_61143_((Property)FramedProperties.Y_AXIS)).booleanValue()) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)yShape);
            }
            if (((Boolean)state.m_61143_((Property)FramedProperties.Z_AXIS)).booleanValue()) {
                shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)zShape);
            }
            builder.put((Object)state, (Object)shape.m_83296_());
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static BooleanProperty getPropFromAxis(Direction dir) {
        return switch (dir.m_122434_()) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.Axis.X -> FramedProperties.X_AXIS;
            case Direction.Axis.Y -> FramedProperties.Y_AXIS;
            case Direction.Axis.Z -> FramedProperties.Z_AXIS;
        };
    }
}

