/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.prism;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.predicate.CtmPredicate;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.DirectionAxis;

public class FramedPrismBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> side == ((DirectionAxis)((Object)((Object)state.m_61143_(PropertyHolder.FACING_AXIS)))).direction().m_122424_();
    public static final CtmPredicate CTM_PREDICATE_INNER = (state, side) -> {
        DirectionAxis dirAxis = (DirectionAxis)((Object)((Object)state.m_61143_(PropertyHolder.FACING_AXIS)));
        return side != dirAxis.direction() && side != null && side.m_122434_() != dirAxis.axis();
    };

    public FramedPrismBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{PropertyHolder.FACING_AXIS, BlockStateProperties.f_61362_, FramedProperties.SOLID, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return FramedPrismBlock.getStateForPlacement(context, this.m_49966_(), this.getBlockType());
    }

    public static BlockState getStateForPlacement(BlockPlaceContext context, BlockState state, IBlockType blockType) {
        Direction.Axis axis;
        Direction face = context.m_43719_();
        if (Utils.isY(face)) {
            axis = context.m_8125_().m_122434_();
        } else {
            Vec3 subHit = Utils.fraction(context.m_43720_());
            double xz = (Utils.isX(face) ? subHit.m_7094_() : subHit.m_7096_()) - 0.5;
            double y = subHit.m_7098_() - 0.5;
            axis = Math.max(Math.abs(xz), Math.abs(y)) == Math.abs(xz) ? face.m_122427_().m_122434_() : Direction.Axis.Y;
        }
        state = (BlockState)state.m_61124_(PropertyHolder.FACING_AXIS, (Comparable)((Object)DirectionAxis.of(face, axis)));
        if (blockType == BlockType.FRAMED_PRISM) {
            state = FramedPrismBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
        }
        return state;
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        if (player.m_21205_().m_204117_(Utils.WRENCH)) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf((Boolean)state.m_61143_((Property)FramedProperties.Y_SLOPE) == false)));
            return true;
        }
        return false;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        DirectionAxis dirAxis = (DirectionAxis)((Object)state.m_61143_(PropertyHolder.FACING_AXIS));
        return (BlockState)state.m_61124_(PropertyHolder.FACING_AXIS, (Comparable)((Object)dirAxis.rotate(rot)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        DirectionAxis dirAxis = (DirectionAxis)((Object)state.m_61143_(PropertyHolder.FACING_AXIS));
        return (BlockState)state.m_61124_(PropertyHolder.FACING_AXIS, (Comparable)((Object)dirAxis.mirror(mirror)));
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottom = Shapes.m_83124_((VoxelShape)FramedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)0.0, (double)15.5, (double)4.0, (double)16.0), FramedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)8.0, (double)16.0)}).m_83296_();
        VoxelShape shapeTop = Shapes.m_83124_((VoxelShape)FramedPrismBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPrismBlock.m_49796_((double)0.5, (double)12.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0), FramedPrismBlock.m_49796_((double)4.0, (double)8.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0)}).m_83296_();
        VoxelShape shapeXZ = Shapes.m_83124_((VoxelShape)FramedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPrismBlock.m_49796_((double)0.0, (double)0.5, (double)12.0, (double)16.0, (double)15.5, (double)16.0), FramedPrismBlock.m_49796_((double)0.0, (double)4.0, (double)8.0, (double)16.0, (double)12.0, (double)16.0)}).m_83296_();
        VoxelShape shapeY = Shapes.m_83124_((VoxelShape)FramedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)15.5, (double)16.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)12.0, (double)15.5, (double)16.0, (double)16.0), FramedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)8.0, (double)12.0, (double)16.0, (double)16.0)}).m_83296_();
        for (BlockState state : states) {
            DirectionAxis dirAxis = (DirectionAxis)((Object)state.m_61143_(PropertyHolder.FACING_AXIS));
            Direction facing = dirAxis.direction();
            Direction.Axis axis = dirAxis.axis();
            if (Utils.isY(facing)) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE), facing == Direction.UP ? shapeBottom : shapeTop));
                continue;
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, axis == Direction.Axis.Y ? shapeY : shapeXZ));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        VoxelShape shapeBottom = Shapes.m_83124_((VoxelShape)FramedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedPrismBlock.m_49796_((double)12.0, (double)0.0, (double)0.0, (double)15.5, (double)15.5, (double)16.0), FramedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)0.0, (double)4.0, (double)15.5, (double)16.0)});
        VoxelShape shapeTop = Shapes.m_83124_((VoxelShape)FramedPrismBlock.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedPrismBlock.m_49796_((double)12.0, (double)0.5, (double)0.0, (double)15.5, (double)16.0, (double)16.0), FramedPrismBlock.m_49796_((double)0.5, (double)0.5, (double)0.0, (double)4.0, (double)16.0, (double)16.0)});
        VoxelShape shapeXZ = Shapes.m_83124_((VoxelShape)FramedPrismBlock.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)0.5, (double)16.0), FramedPrismBlock.m_49796_((double)0.0, (double)15.5, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedPrismBlock.m_49796_((double)0.0, (double)0.5, (double)0.5, (double)16.0, (double)4.0, (double)16.0), FramedPrismBlock.m_49796_((double)0.0, (double)12.0, (double)0.5, (double)16.0, (double)15.5, (double)16.0)});
        VoxelShape shapeY = Shapes.m_83124_((VoxelShape)FramedPrismBlock.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{FramedPrismBlock.m_49796_((double)15.5, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), FramedPrismBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.5, (double)16.0, (double)16.0), FramedPrismBlock.m_49796_((double)12.0, (double)0.0, (double)0.5, (double)15.5, (double)16.0, (double)16.0), FramedPrismBlock.m_49796_((double)0.5, (double)0.0, (double)0.5, (double)4.0, (double)16.0, (double)16.0)});
        for (BlockState state : states) {
            DirectionAxis dirAxis = (DirectionAxis)((Object)state.m_61143_(PropertyHolder.FACING_AXIS));
            Direction facing = dirAxis.direction();
            Direction.Axis axis = dirAxis.axis();
            if (Utils.isY(facing)) {
                builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, Direction.m_122387_((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.NEGATIVE), facing == Direction.UP ? shapeBottom : shapeTop));
                continue;
            }
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing.m_122424_(), axis == Direction.Axis.Y ? shapeY : shapeXZ));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

