/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slab;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.FBContent;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedPanelBlock
extends FramedBlock {
    public FramedPanelBlock() {
        super(BlockType.FRAMED_PANEL);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, BlockStateProperties.f_61362_, FramedProperties.SOLID});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = this.m_49966_();
        Direction face = context.m_43719_();
        state = face.m_122434_().m_122479_() ? (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)face.m_122424_()) : (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)context.m_8125_());
        return FramedPanelBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() == ((Block)FBContent.blockFramedPanel.get()).m_5456_()) {
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            if (hit.m_82434_() == facing.m_122424_()) {
                if (!level.m_5776_()) {
                    Direction newFacing = facing == Direction.NORTH || facing == Direction.EAST ? facing : facing.m_122424_();
                    BlockState newState = ((Block)FBContent.blockFramedDoublePanel.get()).m_49966_();
                    Utils.wrapInStateCopy((LevelAccessor)level, pos, player, stack, facing != newFacing, true, () -> level.m_46597_(pos, (BlockState)newState.m_61124_((Property)FramedProperties.FACING_NE, (Comparable)newFacing)));
                    SoundType sound = ((Block)FBContent.blockFramedCube.get()).m_49962_(((Block)FBContent.blockFramedCube.get()).m_49966_());
                    level.m_5594_(null, pos, sound.m_56777_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.8f);
                }
                return InteractionResult.m_19078_((boolean)level.m_5776_());
            }
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return Utils.mirrorFaceBlock(state, mirror);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        VoxelShape shape = FramedPanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, dir, shape));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

