/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.CtmPredicate;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedExtendedSlopePanelBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = (state, side) -> {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        Direction orientation = ((HorizontalRotation)((Object)((Object)state.m_61143_(PropertyHolder.ROTATION)))).withFacing(facing);
        return side == facing || side == orientation.m_122424_();
    };
    private static final Map<HorizontalRotation, VoxelShape> SHAPES = (Map)Util.m_137469_(new EnumMap(HorizontalRotation.class), map -> {
        for (HorizontalRotation rot : HorizontalRotation.values()) {
            VoxelShape shape = Shapes.m_83110_((VoxelShape)FramedExtendedSlopePanelBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0), (VoxelShape)FramedSlopePanelBlock.SHAPES.get((Object)rot).m_83216_(0.0, 0.0, 0.5));
            map.put(rot, shape);
        }
    });

    public FramedExtendedSlopePanelBlock() {
        super(BlockType.FRAMED_EXTENDED_SLOPE_PANEL);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, FramedProperties.SOLID, BlockStateProperties.f_61362_, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Direction facing = context.m_8125_();
        Direction side = context.m_43719_();
        HorizontalRotation rotation = side == facing.m_122424_() ? HorizontalRotation.fromWallCross(context.m_43720_(), side) : HorizontalRotation.fromDirection(facing, side);
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)facing)).m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation));
        return FramedExtendedSlopePanelBlock.withWater(state, (LevelReader)context.m_43725_(), context.m_8083_());
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        double xz;
        Direction face = hit.m_82434_();
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        if (face == rotation.withFacing(dir) && (xz = Utils.fractionInDir(hit.m_82450_(), dir.m_122424_())) > 0.5) {
            face = dir.m_122424_();
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (face.m_122434_() == dir.m_122434_()) {
            HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            return (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return FramedSlopePanelBlock.mirrorPanel(state, mirror);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            VoxelShape shape = SHAPES.get(state.m_61143_(PropertyHolder.ROTATION));
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, shape));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

