/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.slopepanel;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.block.FramedProperties;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.predicate.CtmPredicate;
import xfacthd.framedblocks.api.shapes.ShapeProvider;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.FramedBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedFlatSlopePanelCornerBlock;
import xfacthd.framedblocks.common.block.slopepanel.FramedSlopePanelBlock;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.PropertyHolder;
import xfacthd.framedblocks.common.data.property.HorizontalRotation;

public class FramedFlatExtendedSlopePanelCornerBlock
extends FramedBlock {
    public static final CtmPredicate CTM_PREDICATE = CtmPredicate.HOR_DIR.or((state, side) -> {
        Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        Direction orientation = ((HorizontalRotation)((Object)((Object)state.m_61143_(PropertyHolder.ROTATION)))).withFacing(facing);
        if (side == orientation.m_122424_()) {
            return true;
        }
        Direction rotOrientation = Utils.isPositive(facing) ? orientation.m_175362_(facing.m_122434_()) : orientation.m_175364_(facing.m_122434_());
        return side == rotOrientation.m_122424_();
    });
    private static final VoxelShape PANEL_SHAPE = FramedFlatExtendedSlopePanelCornerBlock.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);

    public FramedFlatExtendedSlopePanelCornerBlock(BlockType type) {
        super(type);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)FramedProperties.Y_SLOPE, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{FramedProperties.FACING_HOR, PropertyHolder.ROTATION, FramedProperties.SOLID, BlockStateProperties.f_61362_, FramedProperties.Y_SLOPE});
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return FramedFlatSlopePanelCornerBlock.getStateForPlacement(this, false, context);
    }

    @Override
    public boolean handleBlockLeftClick(BlockState state, Level level, BlockPos pos, Player player) {
        return IFramedBlock.toggleYSlope(state, level, pos, player);
    }

    @Override
    public BlockState rotate(BlockState state, BlockHitResult hit, Rotation rot) {
        Direction face = hit.m_82434_();
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
        Direction rotDir = rotation.withFacing(dir);
        Direction perpRotDir = rotation.rotate(Rotation.COUNTERCLOCKWISE_90).withFacing(dir);
        if (face == rotDir || face == perpRotDir) {
            if (this.getBlockType() == BlockType.FRAMED_FLAT_EXT_SLOPE_PANEL_CORNER) {
                double xz = Utils.fractionInDir(hit.m_82450_(), dir.m_122424_());
                if (xz > 0.5) {
                    face = dir.m_122424_();
                }
            } else {
                double perpHor;
                Direction perpDir;
                double hor;
                Vec3 vec = Utils.fraction(hit.m_82450_());
                double d = hor = Utils.isX(dir) ? vec.m_7096_() : vec.m_7094_();
                if (!Utils.isPositive(dir)) {
                    hor = 1.0 - hor;
                }
                Direction direction = perpDir = face == rotDir ? perpRotDir : rotDir;
                double d2 = Utils.isY(perpDir) ? vec.m_7098_() : (perpHor = Utils.isX(dir) ? vec.m_7094_() : vec.m_7096_());
                if (perpDir == Direction.DOWN || !Utils.isY(perpDir) && !Utils.isPositive(perpDir)) {
                    perpHor = 1.0 - perpHor;
                }
                if (hor * 2.0 < perpHor) {
                    face = dir.m_122424_();
                }
            }
        }
        return this.rotate(state, face, rot);
    }

    @Override
    public BlockState rotate(BlockState state, Direction face, Rotation rot) {
        Direction dir = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
        if (face.m_122434_() == dir.m_122434_()) {
            HorizontalRotation rotation = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            return (BlockState)state.m_61124_(PropertyHolder.ROTATION, (Comparable)((Object)rotation.rotate(rot)));
        }
        if (Utils.isY(face)) {
            return (BlockState)state.m_61124_((Property)FramedProperties.FACING_HOR, (Comparable)rot.m_55954_(dir));
        }
        return state;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return this.rotate(state, Direction.UP, rot);
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return FramedFlatSlopePanelCornerBlock.mirrorCorner(state, mirror);
    }

    public static ShapeProvider generateShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            VoxelShape shape = Shapes.m_83113_((VoxelShape)FramedSlopePanelBlock.SHAPES.get((Object)rot), (VoxelShape)FramedSlopePanelBlock.SHAPES.get((Object)rot.rotate(Rotation.COUNTERCLOCKWISE_90)), (BooleanOp)BooleanOp.f_82689_).m_83216_(0.0, 0.0, 0.5);
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)PANEL_SHAPE);
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, shape));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }

    public static ShapeProvider generateInnerShapes(ImmutableList<BlockState> states) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (BlockState state : states) {
            HorizontalRotation rot = (HorizontalRotation)((Object)state.m_61143_(PropertyHolder.ROTATION));
            VoxelShape shape = Shapes.m_83110_((VoxelShape)FramedSlopePanelBlock.SHAPES.get((Object)rot), (VoxelShape)FramedSlopePanelBlock.SHAPES.get((Object)rot.rotate(Rotation.COUNTERCLOCKWISE_90))).m_83216_(0.0, 0.0, 0.5);
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)PANEL_SHAPE);
            Direction facing = (Direction)state.m_61143_((Property)FramedProperties.FACING_HOR);
            builder.put((Object)state, (Object)Utils.rotateShape(Direction.NORTH, facing, shape));
        }
        return ShapeProvider.of((Map<BlockState, VoxelShape>)builder.build());
    }
}

